/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.JsonFileConfigStore;
import org.apache.qpid.server.virtualhostnode.AbstractStandardVirtualHostNode;
import org.apache.qpid.server.virtualhostnode.JsonVirtualHostNode;

public class JsonVirtualHostNodeImpl
extends AbstractStandardVirtualHostNode<JsonVirtualHostNodeImpl>
implements JsonVirtualHostNode<JsonVirtualHostNodeImpl> {
    public static final String VIRTUAL_HOST_NODE_TYPE = "JSON";
    @ManagedAttributeField
    private String _storePath;

    @ManagedObjectFactoryConstructor
    public JsonVirtualHostNodeImpl(Map<String, Object> attributes, Broker<?> parent) {
        super(attributes, parent);
    }

    @Override
    protected void writeLocationEventLog() {
        this.getEventLogger().message(this.getConfigurationStoreLogSubject(), ConfigStoreMessages.STORE_LOCATION(this.getStorePath()));
    }

    @Override
    protected DurableConfigurationStore createConfigurationStore() {
        return new JsonFileConfigStore(VirtualHost.class);
    }

    @Override
    public String getStorePath() {
        return this._storePath;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.getId() + ", name=" + this.getName() + ", storePath=" + this.getStorePath() + "]";
    }

    public static Map<String, Collection<String>> getSupportedChildTypes() {
        return Collections.singletonMap(VirtualHost.class.getSimpleName(), JsonVirtualHostNodeImpl.getSupportedVirtualHostTypes(false));
    }
}

