/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public class ListWriter {
    private static final byte ZERO_BYTE_FORMAT_CODE = 69;
    public static final ValueWriter<List> EMPTY_LIST_WRITER = new EmptyListValueWriter();
    private static final ValueWriter.Factory<List> FACTORY = (registry, object) -> object.isEmpty() ? EMPTY_LIST_WRITER : new NonEmptyListWriter(registry, (List)object);

    public static void register(ValueWriter.Registry registry) {
        registry.register(List.class, FACTORY);
    }

    public static class EmptyListValueWriter
    implements ValueWriter<List> {
        @Override
        public int getEncodedSize() {
            return 1;
        }

        @Override
        public void writeToBuffer(QpidByteBuffer buffer) {
            buffer.put((byte)69);
        }
    }

    private static class NonEmptyListWriter
    extends AbstractListWriter<List> {
        private final List _list;
        private int _position = 0;

        public NonEmptyListWriter(ValueWriter.Registry registry, List object) {
            super(registry, object);
            this._list = object;
        }

        @Override
        protected int getCount() {
            return this._list.size();
        }

        @Override
        protected boolean hasNext() {
            return this._position < this.getCount();
        }

        @Override
        protected Object next() {
            return this._list.get(this._position++);
        }

        @Override
        protected void reset() {
            this._position = 0;
        }
    }
}

