/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;

public class RootServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final String _expectedPath;
    private final String _apiDocsPath;
    private final String _filename;

    public RootServlet(String expectedPath, String apiDocsPath, String filename) {
        this._expectedPath = expectedPath;
        this._apiDocsPath = apiDocsPath;
        this._filename = filename;
    }

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block22: {
            String path = request.getServletPath();
            if (this._expectedPath == null || this._expectedPath.equals(path == null ? "" : path)) {
                try (OutputStream output = HttpManagementUtil.getOutputStream(request, response);
                     InputStream fileInput = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/" + this._filename);){
                    if (fileInput != null) {
                        byte[] buffer = new byte[1024];
                        response.setStatus(200);
                        int read = 0;
                        while ((read = fileInput.read(buffer)) > 0) {
                            output.write(buffer, 0, read);
                        }
                    } else {
                        response.sendError(404, "unknown file: " + this._filename);
                    }
                    break block22;
                }
            }
            response.setStatus(404);
            try (OutputStream output = HttpManagementUtil.getOutputStream(request, response);){
                String notFoundMessage = "Unknown path '" + request.getServletPath() + "'. Please read the api docs at " + request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + this._apiDocsPath + "\n";
                output.write(notFoundMessage.getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

