/* ExpressionParser.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionParser.java */
/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.qpid.server.query.engine.parsing;

import java.io.StringReader;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import org.apache.qpid.server.query.engine.exception.Errors;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.query.Order;
import org.apache.qpid.server.query.engine.parsing.query.OrderItem;
import org.apache.qpid.server.query.engine.parsing.query.QueryExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;
import org.apache.qpid.server.query.engine.parsing.query.WithItem;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;
import org.apache.qpid.server.query.engine.parsing.expression.set.SetExpression;
import org.apache.qpid.server.query.engine.parsing.factory.AccessorExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.ArithmeticExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.ComparisonExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.ConditionalExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.LiteralExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.LogicExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.FunctionExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.ProjectionExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.SetExpressionFactory;
import org.apache.qpid.server.query.engine.parsing.factory.UnaryExpressionFactory;
import org.apache.qpid.server.query.engine.validation.SelectExpressionValidator;

/**
 * Simplified SQL parser generated by JavaCC
 *
 * Do not edit this .java file directly - it is autogenerated from ExpressionParser.jj
 */
@SuppressWarnings("all")
public class ExpressionParser<T, R> implements ExpressionParserConstants {

    private final SelectExpressionValidator _selectExpressionValidator = new SelectExpressionValidator();

    public ExpressionParser()
    {
        this(new StringReader(""));
    }

    public QueryExpression<T, R> parseQuery(String sql) throws ParseException
    {
        this.ReInit(new StringReader(sql));
        return query();
    }

    public Expression<T, R> parseExpression(String sql) throws ParseException
    {
        this.ReInit(new StringReader(sql));
        return addExpression();
    }

    public String decode(String source)
    {
        final StringBuilder stringBuilder = new StringBuilder();
        for(int i = 1; i < source.length() - 1; i++ )
        {
            char c = source.charAt(i);
            if( c == '"' || c == 0x27)
            {
                i++;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

// ----------------------------------------------------------------------------
// Grammar
// ----------------------------------------------------------------------------
  final public 
QueryExpression<T, R> query() throws ParseException {QueryExpression<T, R> query = new QueryExpression<>();
    WithItem<T, R> withItem;
    List<WithItem<T, R>> withItems = new ArrayList<>();
    boolean distinct = true;
    SetExpression<T, R> left;
    SetExpression<T, R> right;
    OrderItem<T, R> orderItem;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case WITH:{
      jj_consume_token(WITH);
      withItem = withItem();
withItems.add(withItem);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        jj_consume_token(COMMA);
        withItem();
withItems.add(withItem);
      }
      query = query();
query.setWithItems(withItems);
        {if ("" != null) return query;}
      break;
      }
    case SELECT:
    case LBRACKET:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        left = select();
        jj_consume_token(RBRACKET);
        break;
        }
      case SELECT:{
        left = select();
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EXCEPT:
        case INTERSECT:
        case MINUS:
        case UNION:{
          ;
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case UNION:{
          jj_consume_token(UNION);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ALL:
          case DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ALL:{
              jj_consume_token(ALL);
distinct = false;
              break;
              }
            case DISTINCT:{
              jj_consume_token(DISTINCT);
distinct = true;
              break;
              }
            default:
              jj_la1[3] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            ;
          }
          if (jj_2_1(3)) {
            jj_consume_token(LBRACKET);
            right = select();
            jj_consume_token(RBRACKET);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case SELECT:{
              right = select();
              break;
              }
            default:
              jj_la1[5] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
left = (SetExpression<T, R>) SetExpressionFactory.union(distinct, (SetExpression<T, Stream<Map<String, Object>>>) left, (SetExpression<T, Stream<Map<String, Object>>>)right);
          break;
          }
        case EXCEPT:
        case MINUS:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EXCEPT:{
            jj_consume_token(EXCEPT);
            break;
            }
          case MINUS:{
            jj_consume_token(MINUS);
            break;
            }
          default:
            jj_la1[6] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ALL:
          case DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ALL:{
              jj_consume_token(ALL);
distinct = false;
              break;
              }
            case DISTINCT:{
              jj_consume_token(DISTINCT);
distinct = true;
              break;
              }
            default:
              jj_la1[7] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[8] = jj_gen;
            ;
          }
          if (jj_2_2(3)) {
            jj_consume_token(LBRACKET);
            right = select();
            jj_consume_token(RBRACKET);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case SELECT:{
              right = select();
              break;
              }
            default:
              jj_la1[9] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
left = (SetExpression<T, R>) SetExpressionFactory.minus(distinct, (SetExpression<T, Stream<Map<String, Object>>>) left, (SetExpression<T, Stream<Map<String, Object>>>)right);
          break;
          }
        case INTERSECT:{
          jj_consume_token(INTERSECT);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ALL:
          case DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ALL:{
              jj_consume_token(ALL);
distinct = false;
              break;
              }
            case DISTINCT:{
              jj_consume_token(DISTINCT);
distinct = true;
              break;
              }
            default:
              jj_la1[10] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            ;
          }
          if (jj_2_3(3)) {
            jj_consume_token(LBRACKET);
            right = select();
            jj_consume_token(RBRACKET);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case SELECT:{
              right = select();
              break;
              }
            default:
              jj_la1[12] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
left = (SetExpression<T, R>) SetExpressionFactory.intersect(distinct, (SetExpression<T, Stream<Map<String, Object>>>) left, (SetExpression<T, Stream<Map<String, Object>>>)right);
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
query.setSelect(left);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ORDER_BY:{
        jj_consume_token(ORDER_BY);
        orderItem = orderItem();
query.addOrderItem(orderItem);
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[14] = jj_gen;
            break label_3;
          }
          jj_consume_token(COMMA);
          orderItem = orderItem();
query.addOrderItem(orderItem);
        }
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LIMIT:{
        jj_consume_token(LIMIT);
        jj_consume_token(DECIMAL_LITERAL);
query.setLimit((Integer)LiteralExpressionFactory.fromDecimal(token.image).apply(null));
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OFFSET:{
        jj_consume_token(OFFSET);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DECIMAL_LITERAL:{
          jj_consume_token(DECIMAL_LITERAL);
query.setOffset((Integer)LiteralExpressionFactory.fromDecimal(token.image).apply(null));
          break;
          }
        case OCTAL_LITERAL:{
          jj_consume_token(OCTAL_LITERAL);
query.setOffset((Integer)LiteralExpressionFactory.fromOctal(token.image).apply(null));
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        ;
      }
{if ("" != null) return query;}
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public WithItem withItem() throws ParseException {WithItem<T, R> withItem;
    String name;
    String alias;
    List<String> aliases = new ArrayList<>();
    QueryExpression<T, R> query;
    name = identifier();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      alias = identifier();
aliases.add(alias);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          break label_4;
        }
        jj_consume_token(COMMA);
        alias = identifier();
aliases.add(alias);
      }
      jj_consume_token(RBRACKET);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    jj_consume_token(LBRACKET);
    query = query();
    jj_consume_token(RBRACKET);
{if ("" != null) return new WithItem<>(name, aliases, query);}
    throw new Error("Missing return statement in function");
}

  final public OrderItem<T, R> orderItem() throws ParseException {Order order = Order.ASC;
    ExpressionNode<T,R> expression;
    expression = orExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASC:
    case DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASC:{
        jj_consume_token(ASC);
        break;
        }
      case DESC:{
        jj_consume_token(DESC);
order = Order.DESC;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
{if ("" != null) return new OrderItem<>(expression.getAlias(), expression, order);}
    throw new Error("Missing return statement in function");
}

  final public SelectExpression<T, R> select() throws ParseException {SelectExpression<T, R> select = new SelectExpression<>();
    ExpressionNode<T, R> item;
    String domain;
    String alias = null;
    ExpressionNode<T, R> where;
    ExpressionNode<T, R> having;
    ExpressionNode<T, R> groupByItem;
    jj_consume_token(SELECT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ALL:
    case DISTINCT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ALL:{
        jj_consume_token(ALL);
        break;
        }
      case DISTINCT:{
        jj_consume_token(DISTINCT);
select.distinct(true);
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    if (jj_2_4(2)) {
      jj_consume_token(ASTERIX);
      projectItems(select);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FALSE:
      case NOT:
      case NULL:
      case TRUE:
      case DATEADD:
      case DATEDIFF:
      case EXTRACT:
      case POSITION:
      case ASTERIX:
      case LBRACKET:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case FUNCTIONNAME:
      case ID:
      case QUOTED_ID:
      case 95:
      case 96:{
        projectItem(select);
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[26] = jj_gen;
            break label_5;
          }
          jj_consume_token(COMMA);
          projectItem(select);
        }
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
      domain = identifier();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AS:
      case ASTERIX:
      case ID:
      case QUOTED_ID:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AS:{
          jj_consume_token(AS);
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          ;
        }
        alias = identifier();
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        ;
      }
select.from(domain, alias);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case JOIN:
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          break label_6;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
          domain = identifier();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AS:
          case ASTERIX:
          case ID:
          case QUOTED_ID:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AS:{
              jj_consume_token(AS);
              break;
              }
            default:
              jj_la1[31] = jj_gen;
              ;
            }
            alias = identifier();
            break;
            }
          default:
            jj_la1[32] = jj_gen;
            ;
          }
select.from(domain, alias);
          break;
          }
        case JOIN:{
          jj_consume_token(JOIN);
          domain = identifier();
select.join();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AS:
          case ASTERIX:
          case ID:
          case QUOTED_ID:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AS:{
              jj_consume_token(AS);
              break;
              }
            default:
              jj_la1[33] = jj_gen;
              ;
            }
            alias = identifier();
            break;
            }
          default:
            jj_la1[34] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      where = predicate();
select.where(where);
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case GROUP_BY:{
      jj_consume_token(GROUP_BY);
select.resetOrdinal();
      groupByItem = groupItem(select);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          break label_7;
        }
        jj_consume_token(COMMA);
        groupByItem = groupItem(select);
      }
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HAVING:{
      jj_consume_token(HAVING);
      having = predicate();
select.having(having);
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
_selectExpressionValidator.validate(select);
        {if ("" != null) return select;}
    throw new Error("Missing return statement in function");
}

  final public void projectItems(SelectExpression select) throws ParseException {
select.selectAll();
}

  final public void projectItem(SelectExpression<T, R> select) throws ParseException {String alias = null;
    ExpressionNode<T, R> expr;
    if (jj_2_5(2)) {
      expr = orExpression();
    } else if (jj_2_6(2)) {
      jj_consume_token(LBRACKET);
      expr = select();
      jj_consume_token(RBRACKET);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:
    case ASTERIX:
    case ID:
    case QUOTED_ID:
    case 89:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AS:{
        jj_consume_token(AS);
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      alias = identifier();
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
select.selectItem(ProjectionExpressionFactory.projection(expr, alias, select.getOrdinal()));
}

  final public ExpressionNode<T, R> groupItem(SelectExpression select) throws ParseException {ExpressionNode<T, R> expr;
    String alias;
    expr = orExpression();
select.groupBy(ProjectionExpressionFactory.projection(expr, expr.getAlias(), select.getOrdinal()));
        {if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> predicate() throws ParseException {ExpressionNode<T, R> left;
    left = orExpression();
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> orExpression() throws ParseException {ExpressionNode<T, R> left;
    ExpressionNode<T, R> right;
    StringBuilder stringBuilder = new StringBuilder();
    left = andExpression();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_8;
      }
      jj_consume_token(OR);
stringBuilder.append(left.getAlias()).append(" or ");
      right = andExpression();
stringBuilder.append(right.getAlias());
            left = (ExpressionNode<T, R>) LogicExpressionFactory.or(stringBuilder.toString(), left, right);
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> andExpression() throws ParseException {ExpressionNode<T, R> left;
    ExpressionNode<T, R> right;
    StringBuilder stringBuilder = new StringBuilder();
    left = equalityExpression();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_9;
      }
      jj_consume_token(AND);
stringBuilder.append(left.getAlias()).append(" and ");
      right = equalityExpression();
stringBuilder.append(right.getAlias());
            left = (ExpressionNode<T, R>) LogicExpressionFactory.and(stringBuilder.toString(), left, right);
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> equalityExpression() throws ParseException {ExpressionNode<T, R> left;
    ExpressionNode<T, R> right;
    left = comparisonExpression();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IS:
      case NOT_EQUAL:
      case 90:{
        ;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 90:{
        jj_consume_token(90);
        right = comparisonExpression();
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.equalExpression(left, right));
        break;
        }
      case NOT_EQUAL:{
        jj_consume_token(NOT_EQUAL);
        right = comparisonExpression();
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.notEqualExpression(left, right));
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        if (jj_2_7(2)) {
          jj_consume_token(IS);
          jj_consume_token(NULL);
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.isNullExpression(left));
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case IS:{
            jj_consume_token(IS);
            jj_consume_token(NOT);
            jj_consume_token(NULL);
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.isNotNullExpression(left));
            break;
            }
          default:
            jj_la1[47] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> comparisonExpression() throws ParseException {ExpressionNode<T, R> left;
    ExpressionNode<T, R> right;
    ExpressionNode<T, R> low;
    ExpressionNode<T, R> high;
    String t, u;
        boolean not;
        ArrayList<ExpressionNode<T, R>> list;
    StringBuilder stringBuilder = new StringBuilder();
    left = addExpression();
stringBuilder.append(left.getAlias());
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BETWEEN:
      case IN:
      case LIKE:
      case NOT:
      case 91:
      case 92:
      case 93:
      case 94:{
        ;
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 91:{
        jj_consume_token(91);
        right = addExpression();
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.greaterThanExpression(left, right));
        break;
        }
      case 92:{
        jj_consume_token(92);
        right = addExpression();
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.greaterThanOrEqualExpression(left, right));
        break;
        }
      case 93:{
        jj_consume_token(93);
        right = addExpression();
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.lessThanExpression(left, right));
        break;
        }
      case 94:{
        jj_consume_token(94);
        right = addExpression();
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.lessThanOrEqualExpression(left, right));
        break;
        }
      case LIKE:{
u = null;
        jj_consume_token(LIKE);
stringBuilder.append(" " + token.image + " ");
        if (jj_2_8(3)) {
          jj_consume_token(LBRACKET);
          t = stringLiteral();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ESCAPE:{
            jj_consume_token(ESCAPE);
stringBuilder.append(" " + token.image + " ");
            u = stringLiteral();
            break;
            }
          default:
            jj_la1[49] = jj_gen;
            ;
          }
          jj_consume_token(RBRACKET);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case STRING_LITERAL:{
            t = stringLiteral();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ESCAPE:{
              jj_consume_token(ESCAPE);
stringBuilder.append(" " + token.image + " ");
              u = stringLiteral();
              break;
              }
            default:
              jj_la1[50] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[51] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.likeExpression(left, t, u));
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        if (jj_2_12(2)) {
u = null;
          jj_consume_token(NOT);
stringBuilder.append(" " + token.image + " ");
          jj_consume_token(LIKE);
stringBuilder.append(" " + token.image + " ");
          if (jj_2_9(3)) {
            jj_consume_token(LBRACKET);
            t = stringLiteral();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ESCAPE:{
              jj_consume_token(ESCAPE);
stringBuilder.append(" " + token.image + " ");
              u = stringLiteral();
              break;
              }
            default:
              jj_la1[52] = jj_gen;
              ;
            }
            jj_consume_token(RBRACKET);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case STRING_LITERAL:{
              t = stringLiteral();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case ESCAPE:{
                jj_consume_token(ESCAPE);
stringBuilder.append(" " + token.image + " ");
                u = stringLiteral();
                break;
                }
              default:
                jj_la1[53] = jj_gen;
                ;
              }
              break;
              }
            default:
              jj_la1[54] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
left = (ExpressionNode<T, R>) LogicExpressionFactory.negate(LogicExpressionFactory.toFunction(ComparisonExpressionFactory.likeExpression(left, t, u)));
        } else if (jj_2_13(3)) {
          jj_consume_token(BETWEEN);
stringBuilder.append(" " + token.image + " ");
          if (jj_2_10(3)) {
            jj_consume_token(LBRACKET);
stringBuilder.append("(");
            low = addExpression();
stringBuilder.append(low.getAlias());
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AND:{
              jj_consume_token(AND);
              break;
              }
            case COMMA:{
              jj_consume_token(COMMA);
              break;
              }
            default:
              jj_la1[55] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
stringBuilder.append(" " + token.image + " ");
            high = addExpression();
            jj_consume_token(RBRACKET);
stringBuilder.append(")");
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case CASE:
            case FALSE:
            case NOT:
            case NULL:
            case TRUE:
            case DATEADD:
            case DATEDIFF:
            case EXTRACT:
            case POSITION:
            case ASTERIX:
            case LBRACKET:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case OCTAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case STRING_LITERAL:
            case FUNCTIONNAME:
            case ID:
            case QUOTED_ID:
            case 95:
            case 96:{
              low = addExpression();
stringBuilder.append(low.getAlias());
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case AND:{
                jj_consume_token(AND);
                break;
                }
              case COMMA:{
                jj_consume_token(COMMA);
                break;
                }
              default:
                jj_la1[56] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
stringBuilder.append(" " + token.image + " ");
              high = addExpression();
stringBuilder.append(high.getAlias());
              break;
              }
            default:
              jj_la1[57] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.betweenExpression(stringBuilder.toString(), left, low, high));
        } else if (jj_2_14(2)) {
          jj_consume_token(NOT);
stringBuilder.append(" " + token.image + " ");
          jj_consume_token(BETWEEN);
stringBuilder.append(" " + token.image + " ");
          if (jj_2_11(3)) {
            jj_consume_token(LBRACKET);
            low = addExpression();
stringBuilder.append(low.getAlias());
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AND:{
              jj_consume_token(AND);
              break;
              }
            case COMMA:{
              jj_consume_token(COMMA);
              break;
              }
            default:
              jj_la1[58] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
stringBuilder.append(" " + token.image + " ");
            high = addExpression();
stringBuilder.append(high.getAlias());
            jj_consume_token(RBRACKET);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case CASE:
            case FALSE:
            case NOT:
            case NULL:
            case TRUE:
            case DATEADD:
            case DATEDIFF:
            case EXTRACT:
            case POSITION:
            case ASTERIX:
            case LBRACKET:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case OCTAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case STRING_LITERAL:
            case FUNCTIONNAME:
            case ID:
            case QUOTED_ID:
            case 95:
            case 96:{
              low = addExpression();
stringBuilder.append(low.getAlias());
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case AND:{
                jj_consume_token(AND);
                break;
                }
              case COMMA:{
                jj_consume_token(COMMA);
                break;
                }
              default:
                jj_la1[59] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
stringBuilder.append(" " + token.image + " ");
              high = addExpression();
stringBuilder.append(high.getAlias());
              break;
              }
            default:
              jj_la1[60] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
left = (ExpressionNode<T, R>) LogicExpressionFactory.negate(LogicExpressionFactory.toFunction(ComparisonExpressionFactory.betweenExpression(stringBuilder.toString(), left, low, high)));
        } else if (jj_2_15(3)) {
          jj_consume_token(IN);
stringBuilder.append(" " + token.image + " ");
          jj_consume_token(LBRACKET);
stringBuilder.append("(");
          right = orExpression();
list = new ArrayList<>(); list.add( right );
          label_12:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[61] = jj_gen;
              break label_12;
            }
            jj_consume_token(COMMA);
stringBuilder.append(", ");
            right = orExpression();
list.add( right );
          }
          jj_consume_token(RBRACKET);
stringBuilder.append(")");
    left = (ExpressionNode<T, R>) LogicExpressionFactory.toFunction(ComparisonExpressionFactory.inExpression(left, list));
        } else if (jj_2_16(3)) {
          jj_consume_token(IN);
stringBuilder.append(" " + token.image + " ");
          jj_consume_token(LBRACKET);
stringBuilder.append("(");
          right = select();
          jj_consume_token(RBRACKET);
stringBuilder.append(")");
    left = (ExpressionNode<T, R>) ComparisonExpressionFactory.inExpression(left, (SelectExpression) right);
        } else if (jj_2_17(6)) {
          jj_consume_token(NOT);
          jj_consume_token(IN);
          jj_consume_token(LBRACKET);
          right = orExpression();
list = new ArrayList<>(); list.add( right );
          label_13:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[62] = jj_gen;
              break label_13;
            }
            jj_consume_token(COMMA);
            right = orExpression();
list.add( right );
          }
          jj_consume_token(RBRACKET);
stringBuilder.append(")");
            left = (ExpressionNode<T, R>) LogicExpressionFactory.negate(LogicExpressionFactory.toFunction(ComparisonExpressionFactory.inExpression(left, list)));
        } else if (jj_2_18(6)) {
          jj_consume_token(NOT);
          jj_consume_token(IN);
          jj_consume_token(LBRACKET);
          right = select();
          jj_consume_token(RBRACKET);
stringBuilder.append(")");
            left = (ExpressionNode<T, R>) LogicExpressionFactory.negate(LogicExpressionFactory.toFunction(ComparisonExpressionFactory.inExpression(left, (SelectExpression) right)));
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> addExpression() throws ParseException {ExpressionNode<T, R> left;
    ExpressionNode<T, R> right;
    StringBuilder stringBuilder = new StringBuilder();
    left = multExpr();
stringBuilder.append(left.getAlias());
    label_14:
    while (true) {
      if (jj_2_19(2147483647)) {
        ;
      } else {
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 95:{
        jj_consume_token(95);
stringBuilder.append("+");
        right = multExpr();
stringBuilder.append(right.getAlias());
                    left = ArithmeticExpressionFactory.plus(stringBuilder.toString(), left, right);
        break;
        }
      case 96:{
        jj_consume_token(96);
stringBuilder.append("-");
        right = multExpr();
stringBuilder.append(right.getAlias());
                    left = ArithmeticExpressionFactory.minus(stringBuilder.toString(), left, right);
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> multExpr() throws ParseException {ExpressionNode<T, R> left;
    ExpressionNode<T, R> right;
    StringBuilder stringBuilder = new StringBuilder();
    left = unaryExpr();
stringBuilder.append(left.getAlias());
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASTERIX:
      case 97:
      case 98:{
        ;
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        break label_15;
      }
      if (jj_2_20(2)) {
        jj_consume_token(ASTERIX);
stringBuilder.append("*");
        right = unaryExpr();
stringBuilder.append(right.getAlias());
                left = ArithmeticExpressionFactory.multiply(stringBuilder.toString(), left, right);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 97:{
          jj_consume_token(97);
stringBuilder.append("/");
          right = unaryExpr();
stringBuilder.append(right.getAlias());
                left = ArithmeticExpressionFactory.divide(stringBuilder.toString(), left, right);
          break;
          }
        case 98:{
          jj_consume_token(98);
stringBuilder.append("%");
          right = unaryExpr();
stringBuilder.append(right.getAlias());
                left = ArithmeticExpressionFactory.mod(stringBuilder.toString(), left, right);
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> unaryExpr() throws ParseException {String s = null;
    ExpressionNode<T, R> left = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 95:{
      jj_consume_token(95);
      left = unaryExpr();
left.setAlias("+" + left.getAlias());
      break;
      }
    case 96:{
      jj_consume_token(96);
      left = unaryExpr();
left.setAlias("-" + left.getAlias());
            left = UnaryExpressionFactory.negate(left);
      break;
      }
    case NOT:{
      jj_consume_token(NOT);
      left = unaryExpr();
left = (ExpressionNode<T, R>) LogicExpressionFactory.negate(left);
      break;
      }
    case CASE:
    case FALSE:
    case NULL:
    case TRUE:
    case DATEADD:
    case DATEDIFF:
    case EXTRACT:
    case POSITION:
    case ASTERIX:
    case LBRACKET:
    case DECIMAL_LITERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case FUNCTIONNAME:
    case ID:
    case QUOTED_ID:{
      left = primaryExpr();
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> primaryExpr() throws ParseException {ExpressionNode<T, R> left = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DATEADD:
    case DATEDIFF:
    case EXTRACT:
    case POSITION:
    case FUNCTIONNAME:{
      left = functionExpression();
      break;
      }
    case FALSE:
    case NULL:
    case TRUE:
    case DECIMAL_LITERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:{
      left = literal();
      break;
      }
    case ASTERIX:
    case ID:
    case QUOTED_ID:{
      left = chainedVariable();
      break;
      }
    case CASE:{
      left = caseExpression();
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      if (jj_2_21(2)) {
        jj_consume_token(LBRACKET);
        left = orExpression();
        jj_consume_token(RBRACKET);
left.setAlias("(" + left.getAlias() + ")");
      } else if (jj_2_22(2)) {
        jj_consume_token(LBRACKET);
        left = select();
        jj_consume_token(RBRACKET);
left.setAlias("(" + left.getAlias() + ")");
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> caseExpression() throws ParseException {ExpressionNode<T, R> expression;
 List<ExpressionNode<T, R>> conditions = new ArrayList<>();
 List<ExpressionNode<T, R>> outcomes = new ArrayList<>();
    jj_consume_token(CASE);
    label_16:
    while (true) {
      jj_consume_token(WHEN);
      expression = orExpression();
conditions.add(expression);
      jj_consume_token(THEN);
      expression = orExpression();
outcomes.add(expression);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHEN:{
        ;
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        break label_16;
      }
    }
    jj_consume_token(ELSE);
    expression = orExpression();
outcomes.add(expression);
    jj_consume_token(END);
{if ("" != null) return ConditionalExpressionFactory.caseExpression(conditions, outcomes);}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> literal() throws ParseException {Token t;
    String s;
    ExpressionNode<T, ?> left = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL:{
      s = stringLiteral();
left = LiteralExpressionFactory.string(s);
      break;
      }
    case DECIMAL_LITERAL:{
      t = jj_consume_token(DECIMAL_LITERAL);
left = LiteralExpressionFactory.fromDecimal(t.image);
      break;
      }
    case HEX_LITERAL:{
      t = jj_consume_token(HEX_LITERAL);
left = LiteralExpressionFactory.fromHex(t.image);
      break;
      }
    case OCTAL_LITERAL:{
      t = jj_consume_token(OCTAL_LITERAL);
left = LiteralExpressionFactory.fromOctal(t.image);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      t = jj_consume_token(FLOATING_POINT_LITERAL);
left = LiteralExpressionFactory.fromDouble(t.image);
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
left = LiteralExpressionFactory.createTrue();
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
left = LiteralExpressionFactory.createFalse();
      break;
      }
    case NULL:{
      jj_consume_token(NULL);
left = LiteralExpressionFactory.createNull();
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return (ExpressionNode<T, R>) left;}
    throw new Error("Missing return statement in function");
}

  final public String stringLiteral() throws ParseException {Token t;
    t = jj_consume_token(STRING_LITERAL);
{if ("" != null) return decode(t.image);}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> chainedVariable() throws ParseException {ExpressionNode<T, R> variable;
    List<ExpressionNode<R, ?>> args = new ArrayList<>();
    ExpressionNode<T, R> expr;
    StringBuilder builder = new StringBuilder();
    if (jj_2_23(2)) {
      variable = variable();
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case POINT:{
          ;
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          break label_17;
        }
        jj_consume_token(POINT);
builder.append(".");
        expr = variable();
builder.append(expr.getAlias()); args.add((ExpressionNode<R, ?>) expr);
      }
{if ("" != null) return AccessorExpressionFactory.chained(builder.toString(), variable, args);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASTERIX:
      case ID:
      case QUOTED_ID:{
        variable = variable();
{if ("" != null) return variable;}
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> variable() throws ParseException {String s;
    Token t;
    ExpressionNode<T, R> right;
    StringBuilder builder = new StringBuilder();
    if (jj_2_24(2)) {
      s = identifier();
builder.append(s);
      jj_consume_token(99);
builder.append("[");
      right = addExpression();
builder.append(right.getAlias());
      jj_consume_token(100);
builder.append("]");
{if ("" != null) return AccessorExpressionFactory.collection(builder.toString(), s, right);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASTERIX:
      case ID:
      case QUOTED_ID:{
        s = identifier();
{if ("" != null) return AccessorExpressionFactory.delegating(s, s);}
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> functionExpression() throws ParseException {String s = null;
    Token t = null;
    List<ExpressionNode<T, ?>> args = new ArrayList<>();
    ExpressionNode<T, R> expr;
    StringBuilder builder = new StringBuilder();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case POSITION:{
      expr = functionPosition();
{if ("" != null) return expr;}
      break;
      }
    case DATEADD:{
      expr = functionDateAdd();
{if ("" != null) return expr;}
      break;
      }
    case DATEDIFF:{
      expr = functionDateDiff();
{if ("" != null) return expr;}
      break;
      }
    case EXTRACT:{
      expr = functionExtract();
{if ("" != null) return expr;}
      break;
      }
    case FUNCTIONNAME:{
      t = jj_consume_token(FUNCTIONNAME);
builder.append(token.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DISTINCT:{
        jj_consume_token(DISTINCT);
builder.append(token.image).append(" "); args.add(LiteralExpressionFactory.string("distinct"));
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case FALSE:
      case NOT:
      case NULL:
      case TRUE:
      case DATEADD:
      case DATEDIFF:
      case EXTRACT:
      case POSITION:
      case ASTERIX:
      case LBRACKET:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case FUNCTIONNAME:
      case ID:
      case QUOTED_ID:
      case 95:
      case 96:{
        expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[75] = jj_gen;
            break label_18;
          }
          jj_consume_token(COMMA);
builder.append(", ");
          expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
        }
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
builder.append(")");
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
String functionName = t.image.substring(0, t.image.length() - 1);
        {if ("" != null) return FunctionExpressionFactory.createFunction(builder.toString(), functionName, args);}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> functionDateAdd() throws ParseException {Token t;
    ExpressionNode<T, R> expr;
    List<ExpressionNode<T, ?>> args = new ArrayList<>();
    StringBuilder builder = new StringBuilder();
    t = jj_consume_token(DATEADD);
builder.append(token.image);
    jj_consume_token(LBRACKET);
builder.append("(");
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DAY:
    case HOUR:
    case MILLISECOND:
    case MINUTE:
    case MONTH:
    case SECOND:
    case WEEK:
    case YEAR:
    case COMMA:{
      expr = datePart();
builder.append(token.image); args.add(expr);
      jj_consume_token(COMMA);
builder.append(", ");
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      jj_consume_token(COMMA);
builder.append(", ");
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
builder.append(", ");
        expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      }
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
builder.append(")");
String functionName = t.image;
        {if ("" != null) return FunctionExpressionFactory.createFunction(builder.toString(), functionName, args);}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> functionDateDiff() throws ParseException {Token t;
    ExpressionNode<T, R> expr;
    List<ExpressionNode<T, ?>> args = new ArrayList<>();
    StringBuilder builder = new StringBuilder();
    t = jj_consume_token(DATEDIFF);
builder.append(token.image);
    jj_consume_token(LBRACKET);
builder.append("(");
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DAY:
    case HOUR:
    case MILLISECOND:
    case MINUTE:
    case MONTH:
    case SECOND:
    case WEEK:
    case YEAR:
    case COMMA:{
      expr = datePart();
builder.append(token.image); args.add(expr);
      jj_consume_token(COMMA);
builder.append(", ");
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      jj_consume_token(COMMA);
builder.append(", ");
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
builder.append(", ");
        expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      }
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
builder.append(")");
String functionName = t.image;
        {if ("" != null) return FunctionExpressionFactory.createFunction(builder.toString(), functionName, args);}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> functionExtract() throws ParseException {Token t;
    ExpressionNode<T, R> expr;
    List<ExpressionNode<T, ?>> args = new ArrayList<>();
    StringBuilder builder = new StringBuilder();
    t = jj_consume_token(EXTRACT);
builder.append(token.image);
    jj_consume_token(LBRACKET);
builder.append("(");
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DAY:
    case FROM:
    case HOUR:
    case MILLISECOND:
    case MINUTE:
    case MONTH:
    case SECOND:
    case WEEK:
    case YEAR:{
      expr = datePart();
builder.append(token.image); args.add(expr);
      jj_consume_token(FROM);
builder.append(" " + token.image + " ");
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
builder.append(")");
String functionName = t.image;
        {if ("" != null) return FunctionExpressionFactory.createFunction(builder.toString(), functionName, args);}
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> datePart() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case YEAR:{
      t = jj_consume_token(YEAR);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.YEARS);}
      break;
      }
    case MONTH:{
      t = jj_consume_token(MONTH);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.MONTHS);}
      break;
      }
    case WEEK:{
      t = jj_consume_token(WEEK);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.WEEKS);}
      break;
      }
    case DAY:{
      t = jj_consume_token(DAY);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.DAYS);}
      break;
      }
    case HOUR:{
      t = jj_consume_token(HOUR);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.HOURS);}
      break;
      }
    case MINUTE:{
      t = jj_consume_token(MINUTE);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.MINUTES);}
      break;
      }
    case SECOND:{
      t = jj_consume_token(SECOND);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.SECONDS);}
      break;
      }
    case MILLISECOND:{
      t = jj_consume_token(MILLISECOND);
{if ("" != null) return (ExpressionNode<T, R>) ConstantExpression.of(ChronoUnit.MILLIS);}
      break;
      }
    default:
      jj_la1[83] = jj_gen;
{if (true) throw QueryParsingException.of(Errors.FUNCTION.DATEPART_NOT_SUPPORTED);}
    }
    throw new Error("Missing return statement in function");
}

  final public ExpressionNode<T, R> functionPosition() throws ParseException {Token t;
    ExpressionNode<T, R> expr;
    List<ExpressionNode<T, ?>> args = new ArrayList<>();
    StringBuilder builder = new StringBuilder();
    t = jj_consume_token(POSITION);
builder.append(token.image);
    jj_consume_token(LBRACKET);
builder.append("(");
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CASE:
    case FALSE:
    case NOT:
    case NULL:
    case TRUE:
    case DATEADD:
    case DATEDIFF:
    case EXTRACT:
    case POSITION:
    case ASTERIX:
    case LBRACKET:
    case DECIMAL_LITERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case FUNCTIONNAME:
    case ID:
    case QUOTED_ID:
    case 95:
    case 96:{
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      ;
    }
    if (jj_2_25(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IN:{
        jj_consume_token(IN);
builder.append(" " + token.image + " ");
        break;
        }
      case COMMA:{
        jj_consume_token(COMMA);
builder.append(token.image);
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
    } else {
      ;
    }
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
builder.append(",");
      expr = addExpression();
builder.append(expr.getAlias()); args.add(expr);
    }
    jj_consume_token(RBRACKET);
builder.append(")");
String functionName = t.image;
        {if ("" != null) return FunctionExpressionFactory.createFunction(builder.toString(), functionName, args);}
    throw new Error("Missing return statement in function");
}

  final public String identifier() throws ParseException {Token t;
    StringBuilder rc = new StringBuilder();
    String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:{
      t = jj_consume_token(ID);
s = t.image;
      break;
      }
    case QUOTED_ID:{
      t = jj_consume_token(QUOTED_ID);
s = decode(t.image);
      break;
      }
    case ASTERIX:{
      t = jj_consume_token(ASTERIX);
s = t.image;
      break;
      }
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_3R_literal_754_9_93()
 {
    if (jj_scan_token(DECIMAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_select_363_16_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_3R_select_363_24_56()) return true;
    }
    return false;
  }

  private boolean jj_3R_select_371_7_46()
 {
    if (jj_scan_token(HAVING)) return true;
    if (jj_3R_predicate_417_5_111()) return true;
    return false;
  }

  private boolean jj_3R_select_370_7_45()
 {
    if (jj_scan_token(GROUP_BY)) return true;
    if (jj_3R_groupItem_405_5_112()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_select_370_78_113()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_select_369_7_44()
 {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_predicate_417_5_111()) return true;
    return false;
  }

  private boolean jj_3R_select_365_11_110()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_365_11_120()) {
    jj_scanpos = xsp;
    if (jj_3R_select_367_9_121()) return true;
    }
    return false;
  }

  private boolean jj_3R_select_365_11_120()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_identifier_1023_5_35()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_365_43_125()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_select_367_9_121()
 {
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_identifier_1023_5_35()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_367_59_126()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_literal_747_9_92()
 {
    if (jj_3R_stringLiteral_813_5_25()) return true;
    return false;
  }

  private boolean jj_3R_select_364_7_43()
 {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_identifier_1023_5_35()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_364_38_109()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_select_365_11_110()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_select_363_5_22()
 {
    if (jj_scan_token(SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_363_16_38()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_select_363_114_39()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_select_364_7_43()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_369_7_44()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_370_7_45()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_select_371_7_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_literal_746_5_79()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_literal_747_9_92()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_754_9_93()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_761_9_94()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_768_9_95()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_775_9_96()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_782_9_97()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_789_9_98()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_796_9_99()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_caseExpression_730_11_102()
 {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    return false;
  }

  private boolean jj_3R_caseExpression_729_5_81()
 {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    if (jj_3R_caseExpression_730_11_102()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_caseExpression_730_11_102()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_select_363_5_22()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_711_9_72()
 {
    if (jj_3R_caseExpression_729_5_81()) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_709_9_71()
 {
    if (jj_3R_chainedVariable_827_5_80()) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_707_9_70()
 {
    if (jj_3R_literal_746_5_79()) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_705_9_69()
 {
    if (jj_3R_functionExpression_871_5_78()) return true;
    return false;
  }

  private boolean jj_3R_functionPosition_1004_91_114()
 {
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_704_5_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_primaryExpr_705_9_69()) {
    jj_scanpos = xsp;
    if (jj_3R_primaryExpr_707_9_70()) {
    jj_scanpos = xsp;
    if (jj_3R_primaryExpr_709_9_71()) {
    jj_scanpos = xsp;
    if (jj_3R_primaryExpr_711_9_72()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_select_363_5_22()) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_692_9_51()
 {
    if (jj_3R_primaryExpr_704_5_65()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_select_363_5_22()) return true;
    return false;
  }

  private boolean jj_3R_functionPosition_1006_74_37()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_687_9_50()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_unaryExpr_678_5_32()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_select_363_5_22()) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_681_9_49()
 {
    if (jj_scan_token(96)) return true;
    if (jj_3R_unaryExpr_678_5_32()) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_679_9_48()
 {
    if (jj_scan_token(95)) return true;
    if (jj_3R_unaryExpr_678_5_32()) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_678_5_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_unaryExpr_679_9_48()) {
    jj_scanpos = xsp;
    if (jj_3R_unaryExpr_681_9_49()) {
    jj_scanpos = xsp;
    if (jj_3R_unaryExpr_687_9_50()) {
    jj_scanpos = xsp;
    if (jj_3R_unaryExpr_692_9_51()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_multExpr_661_9_64()
 {
    if (jj_scan_token(98)) return true;
    if (jj_3R_unaryExpr_678_5_32()) return true;
    return false;
  }

  private boolean jj_3R_multExpr_655_9_63()
 {
    if (jj_scan_token(97)) return true;
    if (jj_3R_unaryExpr_678_5_32()) return true;
    return false;
  }

  private boolean jj_3R_identifier_1034_9_55()
 {
    if (jj_scan_token(ASTERIX)) return true;
    return false;
  }

  private boolean jj_3R_multExpr_648_9_47()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_multExpr_655_9_63()) {
    jj_scanpos = xsp;
    if (jj_3R_multExpr_661_9_64()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(ASTERIX)) return true;
    if (jj_3R_unaryExpr_678_5_32()) return true;
    return false;
  }

  private boolean jj_3R_identifier_1029_9_54()
 {
    if (jj_scan_token(QUOTED_ID)) return true;
    return false;
  }

  private boolean jj_3R_multExpr_646_5_31()
 {
    if (jj_3R_unaryExpr_678_5_32()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_multExpr_648_9_47()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_identifier_1024_9_53()
 {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_functionPosition_1006_22_36()
 {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_identifier_1023_5_35()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_identifier_1024_9_53()) {
    jj_scanpos = xsp;
    if (jj_3R_identifier_1029_9_54()) {
    jj_scanpos = xsp;
    if (jj_3R_identifier_1034_9_55()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_addExpression_627_17_61()
 {
    if (jj_scan_token(96)) return true;
    if (jj_3R_multExpr_646_5_31()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    if (jj_3R_multExpr_646_5_31()) return true;
    return false;
  }

  private boolean jj_3R_addExpression_621_17_60()
 {
    if (jj_scan_token(95)) return true;
    if (jj_3R_multExpr_646_5_31()) return true;
    return false;
  }

  private boolean jj_3R_addExpression_619_13_42()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_addExpression_621_17_60()) {
    jj_scanpos = xsp;
    if (jj_3R_addExpression_627_17_61()) return true;
    }
    return false;
  }

  private boolean jj_3R_functionPosition_1008_7_115()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionPosition_1006_22_36()) {
    jj_scanpos = xsp;
    if (jj_3R_functionPosition_1006_74_37()) return true;
    }
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_functionPosition_1004_5_103()
 {
    if (jj_scan_token(POSITION)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionPosition_1004_91_114()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_functionPosition_1008_7_115()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_addExpression_617_5_28()
 {
    if (jj_3R_multExpr_646_5_31()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_addExpression_619_13_42()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_datePart_991_5_135()
 {
    return false;
  }

  private boolean jj_3R_datePart_989_5_134()
 {
    if (jj_scan_token(MILLISECOND)) return true;
    return false;
  }

  private boolean jj_3R_datePart_987_5_133()
 {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_select_363_5_22()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_datePart_985_5_132()
 {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  private boolean jj_3R_datePart_983_5_131()
 {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_593_11_30()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    return false;
  }

  private boolean jj_3R_datePart_981_5_130()
 {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_comparisonExpression_593_11_30()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_datePart_979_5_129()
 {
    if (jj_scan_token(WEEK)) return true;
    return false;
  }

  private boolean jj_3R_datePart_977_5_128()
 {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  private boolean jj_3R_datePart_975_5_122()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_datePart_975_5_127()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_977_5_128()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_979_5_129()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_981_5_130()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_983_5_131()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_985_5_132()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_987_5_133()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_989_5_134()) {
    jj_scanpos = xsp;
    if (jj_3R_datePart_991_5_135()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_datePart_975_5_127()
 {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_select_363_5_22()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_547_46_27()
 {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_stringLiteral_813_5_25()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_579_11_138()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_571_17_137()
 {
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) return true;
    }
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_orExpression_431_5_24()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_comparisonExpression_579_11_138()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) return true;
    }
    if (jj_3R_addExpression_617_5_28()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_functionExtract_959_9_118()
 {
    if (jj_3R_datePart_975_5_122()) return true;
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_549_35_140()
 {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_stringLiteral_813_5_25()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_536_46_26()
 {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_stringLiteral_813_5_25()) return true;
    return false;
  }

  private boolean jj_3R_functionExtract_956_5_106()
 {
    if (jj_scan_token(EXTRACT)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionExtract_959_9_118()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(BETWEEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_571_17_137()) return true;
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_538_35_139()
 {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_stringLiteral_813_5_25()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_560_13_29()
 {
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) return true;
    }
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) return true;
    }
    if (jj_3R_addExpression_617_5_28()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_functionDateDiff_937_11_124()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_scan_token(BETWEEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_560_13_29()) return true;
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_549_13_136()
 {
    if (jj_3R_stringLiteral_813_5_25()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_549_35_140()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_stringLiteral_813_5_25()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_547_46_27()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_functionDateDiff_931_9_117()
 {
    if (jj_3R_datePart_975_5_122()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_functionDateDiff_937_11_124()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(LIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_549_13_136()) return true;
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_538_13_101()
 {
    if (jj_3R_stringLiteral_813_5_25()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_538_35_139()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_functionDateDiff_928_5_105()
 {
    if (jj_scan_token(DATEDIFF)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionDateDiff_931_9_117()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_stringLiteral_813_5_25()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_536_46_26()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_533_9_86()
 {
    if (jj_scan_token(LIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_538_13_101()) return true;
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_528_9_85()
 {
    if (jj_scan_token(94)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_functionDateAdd_909_11_123()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_523_9_84()
 {
    if (jj_scan_token(93)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_functionDateAdd_903_9_116()
 {
    if (jj_3R_datePart_975_5_122()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_functionDateAdd_909_11_123()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_518_9_83()
 {
    if (jj_scan_token(92)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_513_9_73()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_513_9_82()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_518_9_83()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_523_9_84()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_528_9_85()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_533_9_86()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_513_9_82()
 {
    if (jj_scan_token(91)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_functionDateAdd_900_5_104()
 {
    if (jj_scan_token(DATEADD)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionDateAdd_903_9_116()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_511_5_66()
 {
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_comparisonExpression_513_9_73()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_functionExpression_883_11_119()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_882_11_108()
 {
    if (jj_3R_addExpression_617_5_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_functionExpression_883_11_119()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_functionExpression_881_11_107()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_880_9_91()
 {
    if (jj_scan_token(FUNCTIONNAME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionExpression_881_11_107()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionExpression_882_11_108()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_878_9_90()
 {
    if (jj_3R_functionExtract_956_5_106()) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_876_9_89()
 {
    if (jj_3R_functionDateDiff_928_5_105()) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_874_9_88()
 {
    if (jj_3R_functionDateAdd_900_5_104()) return true;
    return false;
  }

  private boolean jj_3R_select_363_135_62()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_projectItem_393_5_57()) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_489_9_76()
 {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_872_9_87()
 {
    if (jj_3R_functionPosition_1004_5_103()) return true;
    return false;
  }

  private boolean jj_3R_projectItem_393_101_77()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_functionExpression_871_5_78()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionExpression_872_9_87()) {
    jj_scanpos = xsp;
    if (jj_3R_functionExpression_874_9_88()) {
    jj_scanpos = xsp;
    if (jj_3R_functionExpression_876_9_89()) {
    jj_scanpos = xsp;
    if (jj_3R_functionExpression_878_9_90()) {
    jj_scanpos = xsp;
    if (jj_3R_functionExpression_880_9_91()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_projectItem_393_99_68()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_projectItem_393_101_77()) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    if (jj_3R_identifier_1023_5_35()) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_478_9_75()
 {
    if (jj_scan_token(NOT_EQUAL)) return true;
    if (jj_3R_comparisonExpression_511_5_66()) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_473_9_67()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_equalityExpression_473_9_74()) {
    jj_scanpos = xsp;
    if (jj_3R_equalityExpression_478_9_75()) {
    jj_scanpos = xsp;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_equalityExpression_489_9_76()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_equalityExpression_473_9_74()
 {
    if (jj_scan_token(90)) return true;
    if (jj_3R_comparisonExpression_511_5_66()) return true;
    return false;
  }

  private boolean jj_3R_variable_856_5_52()
 {
    if (jj_3R_identifier_1023_5_35()) return true;
    return false;
  }

  private boolean jj_3R_select_363_114_39()
 {
    if (jj_3R_projectItem_393_5_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_select_363_135_62()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_equalityExpression_471_5_58()
 {
    if (jj_3R_comparisonExpression_511_5_66()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_equalityExpression_473_9_67()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_chainedVariable_828_29_34()
 {
    if (jj_scan_token(POINT)) return true;
    if (jj_3R_variable_847_5_33()) return true;
    return false;
  }

  private boolean jj_3R_variable_847_5_33()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_variable_856_5_52()) return true;
    }
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_identifier_1023_5_35()) return true;
    if (jj_scan_token(99)) return true;
    if (jj_3R_addExpression_617_5_28()) return true;
    if (jj_scan_token(100)) return true;
    return false;
  }

  private boolean jj_3R_andExpression_454_9_59()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_equalityExpression_471_5_58()) return true;
    return false;
  }

  private boolean jj_3R_andExpression_452_5_40()
 {
    if (jj_3R_equalityExpression_471_5_58()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_andExpression_454_9_59()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_chainedVariable_833_5_100()
 {
    if (jj_3R_variable_847_5_33()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_variable_847_5_33()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_chainedVariable_828_29_34()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_chainedVariable_827_5_80()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_chainedVariable_833_5_100()) return true;
    }
    return false;
  }

  private boolean jj_3R_select_370_78_113()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_groupItem_405_5_112()) return true;
    return false;
  }

  private boolean jj_3R_orExpression_433_9_41()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_andExpression_452_5_40()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_select_363_5_22()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_orExpression_431_5_24()
 {
    if (jj_3R_andExpression_452_5_40()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_orExpression_433_9_41()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_stringLiteral_813_5_25()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(ASTERIX)) return true;
    if (jj_3R_projectItems_382_5_23()) return true;
    return false;
  }

  private boolean jj_3R_select_367_59_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) jj_scanpos = xsp;
    if (jj_3R_identifier_1023_5_35()) return true;
    return false;
  }

  private boolean jj_3R_predicate_417_5_111()
 {
    if (jj_3R_orExpression_431_5_24()) return true;
    return false;
  }

  private boolean jj_3R_literal_796_9_99()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_literal_789_9_98()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_groupItem_405_5_112()
 {
    if (jj_3R_orExpression_431_5_24()) return true;
    return false;
  }

  private boolean jj_3R_select_365_43_125()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) jj_scanpos = xsp;
    if (jj_3R_identifier_1023_5_35()) return true;
    return false;
  }

  private boolean jj_3R_literal_782_9_97()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_select_364_38_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) jj_scanpos = xsp;
    if (jj_3R_identifier_1023_5_35()) return true;
    return false;
  }

  private boolean jj_3R_literal_775_9_96()
 {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_orExpression_431_5_24()) return true;
    return false;
  }

  private boolean jj_3R_projectItem_393_5_57()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_projectItem_393_99_68()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_literal_768_9_95()
 {
    if (jj_scan_token(OCTAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_select_363_24_56()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_projectItems_382_5_23()
 {
    return false;
  }

  private boolean jj_3R_literal_761_9_94()
 {
    if (jj_scan_token(HEX_LITERAL)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[88];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x20810000,0x1010,0x1010,0x0,0x20010000,0x1010,0x1010,0x0,0x1010,0x1010,0x0,0x20810000,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x880,0x880,0x1010,0x1010,0x0,0x20200,0x40,0x40,0x2000000,0x40,0x40,0x40,0x40,0x2000000,0x40000,0x0,0x0,0x80000,0x100000,0x40,0x40,0x0,0x20,0x1000000,0x0,0x1000000,0x4400100,0x8000,0x8000,0x0,0x8000,0x8000,0x0,0x20,0x20,0x20200,0x20,0x20,0x20200,0x0,0x0,0x4000000,0x0,0x0,0x0,0x20200,0x20200,0x0,0x20000,0x0,0x0,0x0,0x1000,0x0,0x20200,0x0,0x0,0xd0200400,0x0,0xd0200400,0xd0240400,0xd0200400,0x20200,0x400000,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x80,0x400,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x0,0x0,0x80,0x400,0x0,0x20,0x0,0x0,0x4,0x4080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800203,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3800203,0x0,0x0,0x3800203,0x0,0x0,0x0,0x0,0x0,0x0,0x3800203,0x3800202,0x800,0x202,0x0,0x0,0x0,0x0,0x0,0x3800203,0x3800000,0x0,0xa040,0x0,0xa040,0xa040,0xa040,0x3800203,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x800,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x50000,0x0,0x1000,0x800,0x1000,0x0,0x0,0x0,0x0,0x800,0x81ef1401,0x0,0x1800400,0x800,0x0,0x1800400,0x0,0x1800400,0x800,0x0,0x0,0x800,0x0,0x0,0x0,0x3800400,0x0,0x0,0x4002000,0x4002000,0x0,0x78000000,0x0,0x0,0x200000,0x0,0x0,0x200000,0x800,0x800,0x81ef1401,0x800,0x800,0x81ef1401,0x800,0x800,0x78000000,0x80000000,0x400,0x0,0x81ef1401,0x1ef0401,0x0,0x2f0000,0x8000,0x1800400,0x1800400,0x0,0x800,0x81ef1401,0x400001,0x800,0x800,0x800,0x800,0x0,0x0,0x81ef1401,0x800,0x800,0x1800400,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x6,0x6,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[25];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public ExpressionParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ExpressionParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new ExpressionParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 88; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 88; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ExpressionParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 88; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new ExpressionParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 88; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionParser(ExpressionParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 88; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 88; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[101];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 88; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 101; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 25; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
