/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.client.message.TypedBytesCodes;

class TypedBytesContentWriter
implements TypedBytesCodes {
    private final ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    private final DataOutputStream _data = new DataOutputStream(this._baos);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    TypedBytesContentWriter() {
    }

    protected void writeTypeDiscriminator(byte type) throws JMSException {
        try {
            this._data.writeByte(type);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    private JMSException handle(IOException e) {
        JMSException jmsEx = new JMSException("Unable to write value: " + e.getMessage());
        jmsEx.setLinkedException((Exception)e);
        return jmsEx;
    }

    protected void writeBoolean(boolean b) throws JMSException {
        this.writeTypeDiscriminator((byte)1);
        this.writeBooleanImpl(b);
    }

    public void writeBooleanImpl(boolean b) throws JMSException {
        try {
            this._data.writeByte(b ? 1 : 0);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeByte(byte b) throws JMSException {
        this.writeTypeDiscriminator((byte)2);
        this.writeByteImpl(b);
    }

    public void writeByteImpl(byte b) throws JMSException {
        try {
            this._data.writeByte(b);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeShort(short i) throws JMSException {
        this.writeTypeDiscriminator((byte)4);
        this.writeShortImpl(i);
    }

    public void writeShortImpl(short i) throws JMSException {
        try {
            this._data.writeShort(i);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeChar(char c) throws JMSException {
        this.writeTypeDiscriminator((byte)5);
        this.writeCharImpl(c);
    }

    public void writeCharImpl(char c) throws JMSException {
        try {
            this._data.writeChar(c);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeInt(int i) throws JMSException {
        this.writeTypeDiscriminator((byte)6);
        this.writeIntImpl(i);
    }

    protected void writeIntImpl(int i) throws JMSException {
        try {
            this._data.writeInt(i);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeLong(long l) throws JMSException {
        this.writeTypeDiscriminator((byte)7);
        this.writeLongImpl(l);
    }

    public void writeLongImpl(long l) throws JMSException {
        try {
            this._data.writeLong(l);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeFloat(float v) throws JMSException {
        this.writeTypeDiscriminator((byte)8);
        this.writeFloatImpl(v);
    }

    public void writeFloatImpl(float v) throws JMSException {
        try {
            this._data.writeFloat(v);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeDouble(double v) throws JMSException {
        this.writeTypeDiscriminator((byte)9);
        this.writeDoubleImpl(v);
    }

    public void writeDoubleImpl(double v) throws JMSException {
        try {
            this._data.writeDouble(v);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeString(String string) throws JMSException {
        if (string == null) {
            this.writeTypeDiscriminator((byte)11);
        } else {
            this.writeTypeDiscriminator((byte)10);
            this.writeNullTerminatedStringImpl(string);
        }
    }

    protected void writeNullTerminatedStringImpl(String string) throws JMSException {
        try {
            this._data.write(string.getBytes(UTF8));
            this._data.writeByte(0);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeBytes(byte[] bytes) throws JMSException {
        this.writeBytes(bytes, 0, bytes == null ? 0 : bytes.length);
    }

    protected void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.writeTypeDiscriminator((byte)3);
        this.writeBytesImpl(bytes, offset, length);
    }

    public void writeBytesImpl(byte[] bytes, int offset, int length) throws JMSException {
        try {
            if (bytes == null) {
                this._data.writeInt(-1);
            } else {
                this._data.writeInt(length);
                this._data.write(bytes, offset, length);
            }
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    public void writeBytesRaw(byte[] bytes, int offset, int length) throws JMSException {
        try {
            if (bytes != null) {
                this._data.write(bytes, offset, length);
            }
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    protected void writeObject(Object object) throws JMSException {
        Class clazz = object == null ? String.class : object.getClass();
        if (clazz == Byte.class) {
            this.writeByte((Byte)object);
        } else if (clazz == Boolean.class) {
            this.writeBoolean((Boolean)object);
        } else if (clazz == byte[].class) {
            this.writeBytes((byte[])object);
        } else if (clazz == Short.class) {
            this.writeShort((Short)object);
        } else if (clazz == Character.class) {
            this.writeChar(((Character)object).charValue());
        } else if (clazz == Integer.class) {
            this.writeInt((Integer)object);
        } else if (clazz == Long.class) {
            this.writeLong((Long)object);
        } else if (clazz == Float.class) {
            this.writeFloat(((Float)object).floatValue());
        } else if (clazz == Double.class) {
            this.writeDouble((Double)object);
        } else if (clazz == String.class) {
            this.writeString((String)object);
        } else {
            throw new MessageFormatException("Only primitives plus byte arrays and String are valid types");
        }
    }

    public ByteBuffer getData() {
        return ByteBuffer.wrap(this._baos.toByteArray());
    }

    public void writeLengthPrefixedUTF(String string) throws JMSException {
        try {
            CharsetEncoder encoder = UTF8.newEncoder();
            ByteBuffer encodedString = encoder.encode(CharBuffer.wrap(string));
            this.writeShortImpl((short)encodedString.limit());
            while (encodedString.hasRemaining()) {
                this._data.writeByte(encodedString.get());
            }
        }
        catch (CharacterCodingException e) {
            JMSException jmse = new JMSException("Unable to encode string: " + e);
            jmse.setLinkedException((Exception)e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }
}

