/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.JmsTransactionContext;
import org.apache.qpid.jms.JmsTransactionListener;
import org.apache.qpid.jms.JmsTransactionSynchronization;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsResourceId;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsLocalTransactionContext
implements JmsTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(JmsLocalTransactionContext.class);
    private final List<JmsTransactionSynchronization> synchronizations = new ArrayList<JmsTransactionSynchronization>();
    private final Map<JmsResourceId, JmsResourceId> participants = new HashMap<JmsResourceId, JmsResourceId>();
    private final JmsSession session;
    private final JmsConnection connection;
    private JmsTransactionInfo transactionInfo;
    private JmsTransactionListener listener;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public JmsLocalTransactionContext(JmsSession session) {
        this.session = session;
        this.connection = session.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(JmsConnection connection, final JmsOutboundMessageDispatch envelope) throws JMSException {
        this.lock.readLock().lock();
        try {
            if (this.isInDoubt()) {
                return;
            }
            connection.send(envelope, new ProviderSynchronization(){

                @Override
                public void onPendingSuccess() {
                    LOG.trace("TX:{} has performed a send.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                    JmsLocalTransactionContext.this.participants.put(envelope.getProducerId(), envelope.getProducerId());
                }

                @Override
                public void onPendingFailure(Throwable cause) {
                    LOG.trace("TX:{} has a failed send.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                    JmsLocalTransactionContext.this.participants.put(envelope.getProducerId(), envelope.getProducerId());
                }
            });
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(JmsConnection connection, final JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType) throws JMSException {
        if (ackType == ProviderConstants.ACK_TYPE.ACCEPTED || ackType == ProviderConstants.ACK_TYPE.DELIVERED) {
            this.lock.readLock().lock();
            try {
                connection.acknowledge(envelope, ackType, new ProviderSynchronization(){

                    @Override
                    public void onPendingSuccess() {
                        LOG.trace("TX:{} has performed a acknowledge.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                        JmsLocalTransactionContext.this.participants.put(envelope.getConsumerId(), envelope.getConsumerId());
                    }

                    @Override
                    public void onPendingFailure(Throwable cause) {
                        LOG.trace("TX:{} has failed a acknowledge.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                        JmsLocalTransactionContext.this.participants.put(envelope.getConsumerId(), envelope.getConsumerId());
                    }
                });
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            connection.acknowledge(envelope, ackType);
        }
    }

    @Override
    public void addSynchronization(JmsTransactionSynchronization sync) throws JMSException {
        this.lock.writeLock().lock();
        try {
            if (sync.validate(this)) {
                this.synchronizations.add(sync);
            }
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isInDoubt() {
        return this.transactionInfo != null ? this.transactionInfo.isInDoubt() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() throws JMSException {
        this.lock.writeLock().lock();
        try {
            this.reset();
            final JmsTransactionInfo transactionInfo = this.getNextTransactionInfo();
            this.connection.createResource(transactionInfo, new ProviderSynchronization(){

                @Override
                public void onPendingSuccess() {
                    JmsLocalTransactionContext.this.transactionInfo = transactionInfo;
                }

                @Override
                public void onPendingFailure(Throwable cause) {
                    JmsLocalTransactionContext.this.transactionInfo = transactionInfo;
                    transactionInfo.setInDoubt(true);
                }
            });
            if (this.listener != null) {
                try {
                    this.listener.onTransactionStarted();
                }
                catch (Throwable error) {
                    LOG.trace("Local TX listener error ignored: {}", error);
                }
            }
            LOG.debug("Begin: {}", (Object)transactionInfo.getId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws JMSException {
        this.lock.writeLock().lock();
        try {
            if (this.isInDoubt()) {
                try {
                    this.rollback();
                }
                catch (Exception e) {
                    LOG.trace("Error during rollback of failed TX: {}", (Throwable)e);
                }
                throw new TransactionRolledBackException("Transaction failed and has been rolled back.");
            }
            LOG.debug("Commit: {} syncCount: {}", (Object)this.transactionInfo.getId(), (Object)(this.synchronizations != null ? this.synchronizations.size() : 0));
            JmsTransactionId oldTransactionId = this.transactionInfo.getId();
            try {
                this.connection.commit(this.transactionInfo, new ProviderSynchronization(){

                    @Override
                    public void onPendingSuccess() {
                        JmsLocalTransactionContext.this.reset();
                    }

                    @Override
                    public void onPendingFailure(Throwable cause) {
                        JmsLocalTransactionContext.this.reset();
                    }
                });
                if (this.listener != null) {
                    try {
                        this.listener.onTransactionCommitted();
                    }
                    catch (Throwable error) {
                        LOG.trace("Local TX listener error ignored: {}", error);
                    }
                }
                this.afterCommit();
            }
            catch (JMSException cause) {
                LOG.info("Commit failed for transaction: {}", (Object)oldTransactionId);
                if (this.listener != null) {
                    try {
                        this.listener.onTransactionRolledBack();
                    }
                    catch (Throwable error) {
                        LOG.trace("Local TX listener error ignored: {}", error);
                    }
                }
                this.afterRollback();
                throw cause;
            }
            finally {
                LOG.trace("Commit starting new TX after commit completed.");
                this.begin();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void rollback() throws JMSException {
        this.doRollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback(boolean startNewTx) throws JMSException {
        this.lock.writeLock().lock();
        try {
            LOG.debug("Rollback: {} syncCount: {}", (Object)this.transactionInfo.getId(), (Object)(this.synchronizations != null ? this.synchronizations.size() : 0));
            try {
                this.connection.rollback(this.transactionInfo, new ProviderSynchronization(){

                    @Override
                    public void onPendingSuccess() {
                        JmsLocalTransactionContext.this.reset();
                    }

                    @Override
                    public void onPendingFailure(Throwable cause) {
                        JmsLocalTransactionContext.this.reset();
                    }
                });
                if (this.listener != null) {
                    try {
                        this.listener.onTransactionRolledBack();
                    }
                    catch (Throwable error) {
                        LOG.trace("Local TX listener error ignored: {}", error);
                    }
                }
                this.afterRollback();
            }
            finally {
                if (startNewTx) {
                    LOG.trace("Rollback starting new TX after rollback completed.");
                    this.begin();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void shutdown() throws JMSException {
        this.doRollback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionInterrupted() {
        this.lock.writeLock().tryLock();
        try {
            this.transactionInfo.setInDoubt(true);
        }
        finally {
            if (this.lock.writeLock().isHeldByCurrentThread()) {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionRecovery(Provider provider) throws Exception {
        if (this.lock.writeLock().tryLock()) {
            try {
                this.transactionInfo = this.getNextTransactionInfo();
                ProviderFuture request = new ProviderFuture(new ProviderSynchronization(){

                    @Override
                    public void onPendingSuccess() {
                        JmsLocalTransactionContext.this.transactionInfo.setInDoubt(!JmsLocalTransactionContext.this.participants.isEmpty());
                    }

                    @Override
                    public void onPendingFailure(Throwable cause) {
                        JmsLocalTransactionContext.this.transactionInfo.setInDoubt(true);
                    }
                });
                provider.create(this.transactionInfo, request);
                request.sync();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            this.transactionInfo.setInDoubt(true);
        }
    }

    public String toString() {
        return "JmsLocalTransactionContext{ transactionId=" + this.getTransactionId() + " }";
    }

    @Override
    public JmsTransactionId getTransactionId() {
        return this.transactionInfo.getId();
    }

    @Override
    public JmsTransactionListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(JmsTransactionListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isInTransaction() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActiveInThisContext(JmsResourceId resouceId) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.participants.containsKey(resouceId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void reset() {
        this.participants.clear();
    }

    private JmsTransactionInfo getNextTransactionInfo() {
        JmsTransactionId transactionId = this.connection.getNextTransactionId();
        return new JmsTransactionInfo(this.session.getSessionId(), transactionId);
    }

    private void afterRollback() throws JMSException {
        if (this.synchronizations.isEmpty()) {
            return;
        }
        Throwable firstException = null;
        for (JmsTransactionSynchronization sync : this.synchronizations) {
            try {
                sync.afterRollback();
            }
            catch (Throwable thrown) {
                LOG.debug("Exception from afterRollback on " + sync, thrown);
                if (firstException != null) continue;
                firstException = thrown;
            }
        }
        this.synchronizations.clear();
        if (firstException != null) {
            throw JmsExceptionSupport.create(firstException);
        }
    }

    private void afterCommit() throws JMSException {
        if (this.synchronizations.isEmpty()) {
            return;
        }
        Throwable firstException = null;
        for (JmsTransactionSynchronization sync : this.synchronizations) {
            try {
                sync.afterCommit();
            }
            catch (Throwable thrown) {
                LOG.debug("Exception from afterCommit on " + sync, thrown);
                if (firstException != null) continue;
                firstException = thrown;
            }
        }
        this.synchronizations.clear();
        if (firstException != null) {
            throw JmsExceptionSupport.create(firstException);
        }
    }
}

