/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsTemporaryDestination;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpConnectionProperties;
import org.apache.qpid.jms.provider.amqp.AmqpConnectionSession;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpTemporaryDestination;
import org.apache.qpid.jms.provider.amqp.builders.AmqpSessionBuilder;
import org.apache.qpid.jms.provider.amqp.builders.AmqpTemporaryDestinationBuilder;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFactory;
import org.apache.qpid.proton.engine.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnection
extends AmqpAbstractResource<JmsConnectionInfo, Connection>
implements AmqpResourceParent {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnection.class);
    private final AmqpJmsMessageFactory amqpMessageFactory;
    private final URI remoteURI;
    private final Map<JmsSessionId, AmqpSession> sessions = new HashMap<JmsSessionId, AmqpSession>();
    private final Map<JmsDestination, AmqpTemporaryDestination> tempDests = new HashMap<JmsDestination, AmqpTemporaryDestination>();
    private final AmqpProvider provider;
    private final AmqpConnectionProperties properties;
    private AmqpConnectionSession connectionSession;
    private boolean objectMessageUsesAmqpTypes = false;
    private boolean anonymousProducerCache = false;
    private int anonymousProducerCacheSize = 10;

    public AmqpConnection(AmqpProvider provider, JmsConnectionInfo info, Connection protonConnection) {
        super(info, protonConnection, provider);
        this.provider = provider;
        this.remoteURI = provider.getRemoteURI();
        this.amqpMessageFactory = new AmqpJmsMessageFactory(this);
        this.properties = new AmqpConnectionProperties(info);
    }

    public void createSession(JmsSessionInfo sessionInfo, AsyncResult request) {
        AmqpSessionBuilder builder = new AmqpSessionBuilder(this, sessionInfo);
        builder.buildResource(request);
    }

    public void createTemporaryDestination(JmsTemporaryDestination destination, AsyncResult request) {
        AmqpTemporaryDestinationBuilder builder = new AmqpTemporaryDestinationBuilder(this.connectionSession, destination);
        builder.buildResource(request);
    }

    public AmqpTemporaryDestination getTemporaryDestination(JmsTemporaryDestination destination) {
        return this.tempDests.get(destination);
    }

    public void unsubscribe(String subscriptionName, AsyncResult request) {
        for (AmqpSession session : this.sessions.values()) {
            if (!session.containsSubscription(subscriptionName)) continue;
            request.onFailure((Throwable)new JMSException("Cannot remove an active durable subscription"));
            return;
        }
        this.connectionSession.unsubscribe(subscriptionName, request);
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpConnectionSession) {
            this.connectionSession = (AmqpConnectionSession)resource;
        } else if (resource instanceof AmqpSession) {
            AmqpSession session = (AmqpSession)resource;
            this.sessions.put(session.getSessionId(), session);
        } else if (resource instanceof AmqpTemporaryDestination) {
            AmqpTemporaryDestination tempDest = (AmqpTemporaryDestination)resource;
            this.tempDests.put((JmsDestination)tempDest.getResourceInfo(), tempDest);
        }
    }

    @Override
    public void removeChildResource(AmqpResource resource) {
        if (resource instanceof AmqpSession) {
            AmqpSession session = (AmqpSession)resource;
            this.sessions.remove(session.getSessionId());
        } else if (resource instanceof AmqpTemporaryDestination) {
            AmqpTemporaryDestination tempDest = (AmqpTemporaryDestination)resource;
            this.tempDests.remove(tempDest.getResourceInfo());
        }
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    @Override
    public AmqpProvider getProvider() {
        return this.provider;
    }

    public String getQueuePrefix() {
        return this.properties.getQueuePrefix();
    }

    public void setQueuePrefix(String queuePrefix) {
        this.properties.setQueuePrefix(queuePrefix);
    }

    public String getTopicPrefix() {
        return this.properties.getTopicPrefix();
    }

    public void setTopicPrefix(String topicPrefix) {
        this.properties.setTopicPrefix(topicPrefix);
    }

    public AmqpSession getSession(JmsSessionId sessionId) {
        if (sessionId.getProviderHint() instanceof AmqpSession) {
            return (AmqpSession)sessionId.getProviderHint();
        }
        return this.sessions.get(sessionId);
    }

    public boolean isAnonymousProducerCache() {
        return this.anonymousProducerCache;
    }

    public void setAnonymousProducerCache(boolean anonymousProducerCache) {
        this.anonymousProducerCache = anonymousProducerCache;
    }

    public int getAnonymousProducerCacheSize() {
        return this.anonymousProducerCacheSize;
    }

    public void setAnonymousProducerCacheSize(int anonymousProducerCacheSize) {
        this.anonymousProducerCacheSize = anonymousProducerCacheSize;
    }

    public boolean isObjectMessageUsesAmqpTypes() {
        return this.objectMessageUsesAmqpTypes;
    }

    public void setObjectMessageUsesAmqpTypes(boolean objectMessageUsesAmqpTypes) {
        this.objectMessageUsesAmqpTypes = objectMessageUsesAmqpTypes;
    }

    public AmqpJmsMessageFactory getAmqpMessageFactory() {
        return this.amqpMessageFactory;
    }

    public AmqpConnectionProperties getProperties() {
        return this.properties;
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        if (task == null) {
            LOG.trace("Resource attempted to schedule a null task.");
            return null;
        }
        return this.getProvider().getScheduler().schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "AmqpConnection { " + ((JmsConnectionInfo)this.getResourceInfo()).getId() + " }";
    }
}

