/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.concurrent.ScheduledFuture;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.JmsOperationTimedOutException;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.AmqpTransferTagGenerator;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declare;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transaction.Discharge;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionCoordinator
extends AmqpAbstractResource<JmsSessionInfo, Sender> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransactionCoordinator.class);
    private static final Boolean ROLLBACK_MARKER = Boolean.FALSE;
    private static final Boolean COMMIT_MARKER = Boolean.TRUE;
    private final byte[] OUTBOUND_BUFFER = new byte[64];
    private final AmqpTransferTagGenerator tagGenerator = new AmqpTransferTagGenerator();
    private Delivery pendingDelivery;
    private AsyncResult pendingRequest;
    private ScheduledFuture<?> pendingTimeout;

    public AmqpTransactionCoordinator(JmsSessionInfo resourceInfo, Sender endpoint, AmqpResourceParent parent) {
        super(resourceInfo, endpoint, parent);
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider) throws IOException {
        try {
            if (this.pendingDelivery != null && this.pendingDelivery.remotelySettled()) {
                DeliveryState state = this.pendingDelivery.getRemoteState();
                JmsTransactionId txId = (JmsTransactionId)this.pendingDelivery.getContext();
                if (state instanceof Declared) {
                    LOG.debug("New TX started: {}", (Object)txId);
                    Declared declared = (Declared)state;
                    txId.setProviderHint(declared.getTxnId());
                    this.pendingRequest.onSuccess();
                } else if (state instanceof Rejected) {
                    LOG.debug("Last TX request failed: {}", (Object)txId);
                    Rejected rejected = (Rejected)state;
                    Exception cause = AmqpSupport.convertToException(this.getEndpoint(), rejected.getError());
                    Object failureCause = null;
                    failureCause = txId.getProviderContext().equals(COMMIT_MARKER) ? new TransactionRolledBackException(cause.getMessage()) : new JMSException(cause.getMessage());
                    this.pendingRequest.onFailure((Throwable)failureCause);
                } else {
                    LOG.debug("Last TX request succeeded: {}", (Object)txId);
                    this.pendingRequest.onSuccess();
                }
                this.pendingDelivery.settle();
                this.pendingRequest = null;
                this.pendingDelivery = null;
                if (this.pendingTimeout != null) {
                    this.pendingTimeout.cancel(false);
                    this.pendingTimeout = null;
                }
            }
            super.processDeliveryUpdates(provider);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    public void declare(JmsTransactionId txId, AsyncResult request) throws Exception {
        if (txId.getProviderHint() != null) {
            throw new IllegalStateException("Declar called while a TX is still Active.");
        }
        if (this.isClosed()) {
            request.onFailure((Throwable)new JMSException("Cannot start new transaction: Coordinator remotely closed"));
            return;
        }
        Message message = Message.Factory.create();
        Declare declare = new Declare();
        message.setBody((Section)new AmqpValue((Object)declare));
        this.pendingDelivery = ((Sender)this.getEndpoint()).delivery(this.tagGenerator.getNextTag());
        this.pendingDelivery.setContext((Object)txId);
        this.pendingRequest = request;
        this.scheduleTimeoutIfNeeded("Timed out waiting for declare of new TX.");
        this.sendTxCommand(message);
    }

    public void discharge(JmsTransactionId txId, AsyncResult request, boolean commit) throws Exception {
        if (txId.getProviderHint() == null) {
            throw new IllegalStateException("Discharge called with no active Transaction.");
        }
        if (this.isClosed()) {
            Object failureCause = null;
            failureCause = commit ? new TransactionRolledBackException("Transaction inbout: Coordinator remotely closed") : new JMSException("Rollback cannot complete: Coordinator remotely closed");
            request.onFailure((Throwable)failureCause);
            return;
        }
        txId.setProviderContext(commit ? COMMIT_MARKER : ROLLBACK_MARKER);
        Message message = Message.Factory.create();
        Discharge discharge = new Discharge();
        discharge.setFail(Boolean.valueOf(!commit));
        discharge.setTxnId((Binary)txId.getProviderHint());
        message.setBody((Section)new AmqpValue((Object)discharge));
        this.pendingDelivery = ((Sender)this.getEndpoint()).delivery(this.tagGenerator.getNextTag());
        this.pendingDelivery.setContext((Object)txId);
        this.pendingRequest = request;
        this.scheduleTimeoutIfNeeded("Timed out waiting for discharge of TX.");
        this.sendTxCommand(message);
    }

    @Override
    public void remotelyClosed(AmqpProvider provider) {
        Exception txnError = AmqpSupport.convertToException(this.getEndpoint(), ((Sender)this.getEndpoint()).getRemoteCondition());
        if (this.pendingRequest != null) {
            this.pendingRequest.onFailure(txnError);
            this.pendingRequest = null;
        }
        if (this.getParent() != null) {
            this.getParent().removeChildResource(this);
        }
        if (this.getEndpoint() != null) {
            ((Sender)this.getEndpoint()).close();
            ((Sender)this.getEndpoint()).free();
        }
        LOG.debug("Transaction Coordinator link {} was remotely closed", this.getResourceInfo());
    }

    private void scheduleTimeoutIfNeeded(String cause) {
        AmqpProvider provider = this.getParent().getProvider();
        if (provider.getRequestTimeout() != -1L) {
            provider.scheduleRequestTimeout(this.pendingRequest, provider.getRequestTimeout(), (Exception)((Object)new JmsOperationTimedOutException(cause)));
        }
    }

    private void sendTxCommand(Message message) throws IOException {
        int encodedSize = 0;
        byte[] buffer = this.OUTBOUND_BUFFER;
        while (true) {
            try {
                encodedSize = message.encode(buffer, 0, buffer.length);
            }
            catch (BufferOverflowException e) {
                buffer = new byte[buffer.length * 2];
                continue;
            }
            break;
        }
        Sender sender = (Sender)this.getEndpoint();
        sender.send(buffer, 0, encodedSize);
        sender.advance();
    }
}

