/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.util.HashMap;
import javax.jms.InvalidDestinationException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.provider.amqp.filters.AmqpJmsNoLocalType;
import org.apache.qpid.jms.provider.amqp.filters.AmqpJmsSelectorType;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;

public class AmqpConsumerBuilder
extends AmqpResourceBuilder<AmqpConsumer, AmqpSession, JmsConsumerInfo, Receiver> {
    public AmqpConsumerBuilder(AmqpSession parent, JmsConsumerInfo consumerInfo) {
        super(parent, consumerInfo);
    }

    @Override
    protected Receiver createEndpoint(JmsConsumerInfo resourceInfo) {
        JmsDestination destination = resourceInfo.getDestination();
        String subscription = AmqpDestinationHelper.INSTANCE.getDestinationAddress(destination, ((AmqpSession)this.getParent()).getConnection());
        Source source = new Source();
        source.setAddress(subscription);
        Target target = new Target();
        this.configureSource(source);
        String receiverName = "qpid-jms:receiver:" + resourceInfo.getId() + ":" + subscription;
        if (resourceInfo.getSubscriptionName() != null && !resourceInfo.getSubscriptionName().isEmpty()) {
            receiverName = resourceInfo.getSubscriptionName();
        }
        Receiver receiver = ((Session)((AmqpSession)this.getParent()).getEndpoint()).receiver(receiverName);
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        if (resourceInfo.isBrowser() || resourceInfo.isPresettle()) {
            receiver.setSenderSettleMode(SenderSettleMode.SETTLED);
        } else {
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        }
        receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        return receiver;
    }

    @Override
    protected AmqpConsumer createResource(AmqpSession parent, JmsConsumerInfo resourceInfo, Receiver endpoint) {
        return new AmqpConsumer(parent, resourceInfo, endpoint);
    }

    @Override
    protected Exception getOpenAbortException() {
        org.apache.qpid.proton.amqp.transport.Source source = ((Receiver)this.endpoint).getRemoteSource();
        if (source != null) {
            return super.getOpenAbortException();
        }
        return new InvalidDestinationException("Link creation was refused");
    }

    @Override
    protected boolean isClosePending() {
        return ((Receiver)this.endpoint).getRemoteSource() == null;
    }

    private void configureSource(Source source) {
        Symbol typeCapability;
        HashMap<Symbol, Object> filters = new HashMap<Symbol, Object>();
        Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
        if (((JmsConsumerInfo)this.resourceInfo).getSubscriptionName() != null && !((JmsConsumerInfo)this.resourceInfo).getSubscriptionName().isEmpty()) {
            source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setDistributionMode(AmqpSupport.COPY);
        } else {
            source.setDurable(TerminusDurability.NONE);
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        }
        if (((JmsConsumerInfo)this.resourceInfo).isBrowser()) {
            source.setDistributionMode(AmqpSupport.COPY);
        }
        if ((typeCapability = AmqpDestinationHelper.INSTANCE.toTypeCapability(((JmsConsumerInfo)this.resourceInfo).getDestination())) != null) {
            source.setCapabilities(new Symbol[]{typeCapability});
        }
        source.setOutcomes(outcomes);
        source.setDefaultOutcome((Outcome)AmqpSupport.MODIFIED_FAILED);
        if (((JmsConsumerInfo)this.resourceInfo).isNoLocal()) {
            filters.put(AmqpSupport.JMS_NO_LOCAL_SYMBOL, AmqpJmsNoLocalType.NO_LOCAL);
        }
        if (((JmsConsumerInfo)this.resourceInfo).getSelector() != null && !((JmsConsumerInfo)this.resourceInfo).getSelector().trim().equals("")) {
            filters.put(AmqpSupport.JMS_SELECTOR_SYMBOL, new AmqpJmsSelectorType(((JmsConsumerInfo)this.resourceInfo).getSelector()));
        }
        if (!filters.isEmpty()) {
            source.setFilter(filters);
        }
    }
}

