/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.facade.JmsObjectMessageFacade;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.jms.provider.amqp.message.AmqpSerializedObjectDelegate;
import org.apache.qpid.jms.provider.amqp.message.AmqpTypedObjectDelegate;
import org.apache.qpid.proton.message.Message;

public class AmqpJmsObjectMessageFacade
extends AmqpJmsMessageFacade
implements JmsObjectMessageFacade {
    private AmqpObjectTypeDelegate delegate;
    private final JmsDeserializationPolicy deserializationPolicy;

    public AmqpJmsObjectMessageFacade(AmqpConnection connection, boolean isAmqpTypeEncoded) {
        this(connection, isAmqpTypeEncoded, null);
    }

    private AmqpJmsObjectMessageFacade(AmqpConnection connection, boolean isAmqpTypeEncoded, JmsDeserializationPolicy deserializationPolicy) {
        super(connection);
        this.deserializationPolicy = deserializationPolicy;
        this.setMessageAnnotation("x-opt-jms-msg-type", (byte)1);
        this.initDelegate(isAmqpTypeEncoded, null);
    }

    public AmqpJmsObjectMessageFacade(AmqpConsumer consumer, Message message, ByteBuf messageBytes) {
        super(consumer, message);
        this.deserializationPolicy = ((JmsConsumerInfo)consumer.getResourceInfo()).getDeserializationPolicy();
        boolean javaSerialized = "application/x-java-serialized-object".equals(message.getContentType());
        this.initDelegate(!javaSerialized, messageBytes);
    }

    @Override
    public byte getJmsMsgType() {
        return 1;
    }

    public boolean isAmqpTypedEncoding() {
        return this.delegate.isAmqpTypeEncoded();
    }

    @Override
    public AmqpJmsObjectMessageFacade copy() throws JMSException {
        AmqpJmsObjectMessageFacade copy = new AmqpJmsObjectMessageFacade(this.connection, this.isAmqpTypedEncoding(), this.deserializationPolicy);
        this.copyInto(copy);
        try {
            this.delegate.copyInto(copy.delegate);
        }
        catch (Exception ex) {
            throw JmsExceptionSupport.create(ex);
        }
        return copy;
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        return this.delegate.getObject();
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        this.delegate.setObject(value);
    }

    @Override
    public void clearBody() {
        try {
            this.setObject(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onSend(long producerTtl) throws JMSException {
        super.onSend(producerTtl);
        this.delegate.onSend();
    }

    void setUseAmqpTypedEncoding(boolean useAmqpTypedEncoding) throws JMSException {
        if (useAmqpTypedEncoding != this.delegate.isAmqpTypeEncoded()) {
            try {
                Serializable existingObject = this.delegate.getObject();
                AmqpObjectTypeDelegate newDelegate = null;
                newDelegate = useAmqpTypedEncoding ? new AmqpTypedObjectDelegate(this, null) : new AmqpSerializedObjectDelegate(this, null, this.deserializationPolicy);
                newDelegate.setObject(existingObject);
                this.delegate = newDelegate;
            }
            catch (IOException | ClassNotFoundException e) {
                throw JmsExceptionSupport.create(e);
            }
        }
    }

    private void initDelegate(boolean useAmqpTypes, ByteBuf messageBytes) {
        this.delegate = !useAmqpTypes ? new AmqpSerializedObjectDelegate(this, messageBytes, this.deserializationPolicy) : new AmqpTypedObjectDelegate(this, messageBytes);
    }

    AmqpObjectTypeDelegate getDelegate() {
        return this.delegate;
    }
}

