/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.jms.sasl.AbstractMechanism;

abstract class AbstractScramSHAMechanism
extends AbstractMechanism {
    private static final byte[] INT_1 = new byte[]{0, 0, 0, 1};
    private static final String GS2_HEADER = "n,,";
    private final String clientNonce;
    private final String digestName;
    private final String hmacName;
    private String serverNonce;
    private byte[] salt;
    private int iterationCount;
    private String clientFirstMessageBare;
    private byte[] serverSignature;
    private State state = State.INITIAL;

    AbstractScramSHAMechanism(String digestName, String hmacName, String clientNonce) {
        this.digestName = digestName;
        this.hmacName = hmacName;
        this.clientNonce = clientNonce;
    }

    @Override
    public boolean isApplicable(String username, String password, Principal localPrincipal) {
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }

    @Override
    public byte[] getInitialResponse() throws SaslException {
        if (this.state != State.INITIAL) {
            throw new SaslException("Request for initial response not expected in state " + (Object)((Object)this.state));
        }
        StringBuilder buf = new StringBuilder("n=");
        buf.append(this.saslPrep(this.getUsername()));
        buf.append(",r=");
        buf.append(this.clientNonce);
        this.clientFirstMessageBare = buf.toString();
        this.state = State.CLIENT_FIRST_SENT;
        return (GS2_HEADER + this.clientFirstMessageBare).getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public byte[] getChallengeResponse(byte[] challenge) throws SaslException {
        byte[] response;
        switch (this.state) {
            case CLIENT_FIRST_SENT: {
                response = this.calculateClientProof(challenge);
                this.state = State.CLIENT_PROOF_SENT;
                break;
            }
            case CLIENT_PROOF_SENT: {
                this.evaluateOutcome(challenge);
                response = new byte[]{};
                this.state = State.COMPLETE;
                break;
            }
            default: {
                throw new SaslException("No challenge expected in state " + (Object)((Object)this.state));
            }
        }
        return response;
    }

    private byte[] calculateClientProof(byte[] challenge) throws SaslException {
        try {
            String serverFirstMessage = new String(challenge, StandardCharsets.US_ASCII);
            String[] parts = serverFirstMessage.split(",");
            if (parts.length < 3) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed");
            }
            if (parts[0].startsWith("m=")) {
                throw new SaslException("Server requires mandatory extension which is not supported: " + parts[0]);
            }
            if (!parts[0].startsWith("r=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find nonce");
            }
            String nonce = parts[0].substring(2);
            if (!nonce.startsWith(this.clientNonce)) {
                throw new SaslException("Server challenge did not use correct client nonce");
            }
            this.serverNonce = nonce;
            if (!parts[1].startsWith("s=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find salt");
            }
            String base64Salt = parts[1].substring(2);
            this.salt = DatatypeConverter.parseBase64Binary((String)base64Salt);
            if (!parts[2].startsWith("i=")) {
                throw new SaslException("Server challenge '" + serverFirstMessage + "' cannot be parsed, cannot find iteration count");
            }
            String iterCountString = parts[2].substring(2);
            this.iterationCount = Integer.parseInt(iterCountString);
            if (this.iterationCount <= 0) {
                throw new SaslException("Iteration count " + this.iterationCount + " is not a positive integer");
            }
            byte[] passwordBytes = this.saslPrep(new String(this.getPassword())).getBytes(StandardCharsets.UTF_8);
            byte[] saltedPassword = this.generateSaltedPassword(passwordBytes);
            String clientFinalMessageWithoutProof = "c=" + DatatypeConverter.printBase64Binary((byte[])GS2_HEADER.getBytes(StandardCharsets.US_ASCII)) + ",r=" + this.serverNonce;
            String authMessage = this.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] clientKey = this.computeHmac(saltedPassword, "Client Key");
            byte[] storedKey = MessageDigest.getInstance(this.digestName).digest(clientKey);
            byte[] clientSignature = this.computeHmac(storedKey, authMessage);
            byte[] clientProof = (byte[])clientKey.clone();
            for (int i = 0; i < clientProof.length; ++i) {
                int n = i;
                clientProof[n] = (byte)(clientProof[n] ^ clientSignature[i]);
            }
            byte[] serverKey = this.computeHmac(saltedPassword, "Server Key");
            this.serverSignature = this.computeHmac(serverKey, authMessage);
            String finalMessageWithProof = clientFinalMessageWithoutProof + ",p=" + DatatypeConverter.printBase64Binary((byte[])clientProof);
            return finalMessageWithProof.getBytes();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private void evaluateOutcome(byte[] challenge) throws SaslException {
        String serverFinalMessage = new String(challenge, StandardCharsets.US_ASCII);
        String[] parts = serverFinalMessage.split(",");
        if (!parts[0].startsWith("v=")) {
            throw new SaslException("Server final message did not contain verifier");
        }
        byte[] serverSignature = DatatypeConverter.parseBase64Binary((String)parts[0].substring(2));
        if (!Arrays.equals(this.serverSignature, serverSignature)) {
            throw new SaslException("Server signature did not match");
        }
    }

    private byte[] computeHmac(byte[] key, String string) throws SaslException {
        Mac mac = this.createHmac(key);
        mac.update(string.getBytes(StandardCharsets.US_ASCII));
        return mac.doFinal();
    }

    private byte[] generateSaltedPassword(byte[] passwordBytes) throws SaslException {
        Mac mac = this.createHmac(passwordBytes);
        mac.update(this.salt);
        mac.update(INT_1);
        byte[] result = mac.doFinal();
        byte[] previous = null;
        for (int i = 1; i < this.iterationCount; ++i) {
            mac.update(previous != null ? previous : result);
            previous = mac.doFinal();
            for (int x = 0; x < result.length; ++x) {
                int n = x;
                result[n] = (byte)(result[n] ^ previous[x]);
            }
        }
        return result;
    }

    private Mac createHmac(byte[] keyBytes) throws SaslException {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, this.hmacName);
            Mac mac = Mac.getInstance(this.hmacName);
            mac.init(key);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private String saslPrep(String name) throws SaslException {
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(name)) {
            throw new SaslException("Can only encode names and passwords which are restricted to ASCII characters");
        }
        name = name.replace("=", "=3D");
        name = name.replace(",", "=2C");
        return name;
    }

    private static enum State {
        INITIAL,
        CLIENT_FIRST_SENT,
        CLIENT_PROOF_SENT,
        COMPLETE;

    }
}

