/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.rat.ReportFailedRuntimeException;

class ReportTransformer
implements Runnable {
    private final Writer out;
    private final Transformer transformer;
    private final Reader in;

    public ReportTransformer(Writer out, Reader style, Reader in) throws TransformerConfigurationException {
        this.out = out;
        this.transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(style));
        this.in = in;
    }

    public ReportTransformer(Writer out, InputStream style, Reader in) throws TransformerConfigurationException {
        this.out = out;
        this.transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(style));
        this.in = in;
    }

    @Override
    public void run() {
        try {
            this.transform();
        }
        catch (TransformerException e) {
            throw new ReportFailedRuntimeException(e.getMessage(), e);
        }
    }

    public void transform() throws TransformerException {
        this.transformer.transform(new StreamSource(this.in), new StreamResult(this.out));
    }
}

