/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.util.Collection;
import java.util.Collections;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.matchers.AbstractMatcherContainer;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;

class LicenseCollection
extends AbstractMatcherContainer
implements ILicense {
    private static final ILicenseFamily DEFAULT = ILicenseFamily.builder().setLicenseFamilyCategory("Dummy").setLicenseFamilyName("HeaderMatcherCollection default license family").build();
    private final Collection<ILicense> enclosed;
    private ILicense matchingLicense;
    private IHeaderMatcher.State lastState;

    public LicenseCollection(Collection<ILicense> enclosed) {
        super(enclosed);
        this.enclosed = Collections.unmodifiableCollection(enclosed);
        this.matchingLicense = null;
        this.lastState = IHeaderMatcher.State.i;
    }

    @Override
    public String getId() {
        return "Default License Collection";
    }

    @Override
    public void reset() {
        this.enclosed.forEach(IHeaderMatcher::reset);
        this.lastState = IHeaderMatcher.State.i;
        this.matchingLicense = null;
    }

    @Override
    public IHeaderMatcher.State matches(String line) {
        IHeaderMatcher.State dflt = IHeaderMatcher.State.f;
        for (ILicense license : this.enclosed) {
            switch (license.matches(line)) {
                case t: {
                    this.matchingLicense = license;
                    this.lastState = IHeaderMatcher.State.t;
                    return IHeaderMatcher.State.t;
                }
                case i: {
                    dflt = IHeaderMatcher.State.i;
                    break;
                }
            }
        }
        this.lastState = dflt;
        return dflt;
    }

    @Override
    public IHeaderMatcher.State currentState() {
        if (this.lastState == IHeaderMatcher.State.t) {
            return this.lastState;
        }
        for (ILicense license : this.enclosed) {
            switch (license.currentState()) {
                case t: {
                    this.matchingLicense = license;
                    this.lastState = IHeaderMatcher.State.t;
                    return this.lastState;
                }
                case i: {
                    this.lastState = IHeaderMatcher.State.i;
                    return this.lastState;
                }
            }
        }
        this.lastState = IHeaderMatcher.State.f;
        return this.lastState;
    }

    @Override
    public int compareTo(ILicense arg0) {
        return this.getLicenseFamily().compareTo(arg0.getLicenseFamily());
    }

    @Override
    public ILicenseFamily getLicenseFamily() {
        return this.matchingLicense == null ? DEFAULT : this.matchingLicense.getLicenseFamily();
    }

    @Override
    public String getNotes() {
        return this.matchingLicense == null ? null : this.matchingLicense.getNotes();
    }

    @Override
    public String derivedFrom() {
        return this.matchingLicense == null ? null : this.matchingLicense.derivedFrom();
    }

    @Override
    public String getName() {
        return this.getLicenseFamily().getFamilyName();
    }
}

