/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.license.ILicense;

public class MetaData {
    public static final String RAT_BASE_URL = "http://org/apache/rat/meta-data";
    public static final String RAT_URL_DOCUMENT_CATEGORY = "http://org/apache/rat/meta-data#FileCategory";
    public static final String RAT_DOCUMENT_CATEGORY_VALUE_GENERATED = "GEN  ";
    public static final String RAT_DOCUMENT_CATEGORY_VALUE_UNKNOWN = "?????";
    public static final String RAT_DOCUMENT_CATEGORY_VALUE_ARCHIVE = "archive";
    public static final String RAT_DOCUMENT_CATEGORY_VALUE_NOTICE = "notice";
    public static final String RAT_DOCUMENT_CATEGORY_VALUE_BINARY = "binary";
    public static final String RAT_DOCUMENT_CATEGORY_VALUE_STANDARD = "standard";
    public static final Datum RAT_DOCUMENT_CATEGORY_DATUM_GENERATED = new Datum("http://org/apache/rat/meta-data#FileCategory", "GEN  ");
    public static final Datum RAT_DOCUMENT_CATEGORY_DATUM_UNKNOWN = new Datum("http://org/apache/rat/meta-data#FileCategory", "?????");
    public static final Datum RAT_DOCUMENT_CATEGORY_DATUM_ARCHIVE = new Datum("http://org/apache/rat/meta-data#FileCategory", "archive");
    public static final Datum RAT_DOCUMENT_CATEGORY_DATUM_NOTICE = new Datum("http://org/apache/rat/meta-data#FileCategory", "notice");
    public static final Datum RAT_DOCUMENT_CATEGORY_DATUM_BINARY = new Datum("http://org/apache/rat/meta-data#FileCategory", "binary");
    public static final Datum RAT_DOCUMENT_CATEGORY_DATUM_STANDARD = new Datum("http://org/apache/rat/meta-data#FileCategory", "standard");
    public static final String RAT_URL_HEADER_CATEGORY = "http://org/apache/rat/meta-data#HeaderCategory";
    public static final String RAT_URL_LICENSE_FAMILY_CATEGORY = "http://org/apache/rat/meta-data#LicenseFamilyCategory";
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_GEN = "GEN  ";
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_UNKNOWN = "?????";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_ASL = "AL   ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_OASIS = "OASIS";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_W3CD = "W3CD ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_W3C = "W3C  ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_DOJO = "DOJO ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_TMF = "TMF  ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_GPL1 = "GPL1 ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_GPL2 = "GPL2 ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_GPL3 = "GPL3 ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_MIT = "MIT  ";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_CATEGORY_VALUE_CDDL1 = "CDDL1";
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_GEN = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "GEN  ");
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_UNKNOWN = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "?????");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_ASL = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "AL   ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_OASIS = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "OASIS");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_W3CD = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "W3CD ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_W3C = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "W3C  ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_DOJO = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "DOJO ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_TMF = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "TMF  ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_GPL1 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "GPL1 ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_GPL2 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "GPL2 ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_GPL3 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "GPL3 ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_MIT = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "MIT  ");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_CATEGORY_DATUM_CDLL1 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", "CDDL1");
    public static final String RAT_URL_LICENSE_FAMILY_NAME = "http://org/apache/rat/meta-data#LicenseFamilyName";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_W3C_SOFTWARE_COPYRIGHT = "W3C Software Copyright";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_W3C_DOCUMENT_COPYRIGHT = "W3C Document Copyright";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_OASIS_OPEN_LICENSE = "OASIS Open License";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_MODIFIED_BSD_LICENSE = "Modified BSD License";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_APACHE_LICENSE_VERSION_2_0 = "Apache License Version 2.0";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_GPL_VERSION_1 = "GNU General Public License, version 1";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_GPL_VERSION_2 = "GNU General Public License, version 2";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_GPL_VERSION_3 = "GNU General Public License, version 3";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_MIT = "The MIT License";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_CDDL1 = "COMMON DEVELOPMENT AND DISTRIBUTION LICENSE Version 1.0";
    @Deprecated
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_ACADEMIC_FREE_LICENSE_VERSION_2_1 = "Academic Free License, Version 2.1";
    public static final String RAT_LICENSE_FAMILY_NAME_VALUE_UNKNOWN = "?????";
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_W3C_SOFTWARE_COPYRIGHT = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "W3C Software Copyright");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_W3C_DOCUMENT_COPYRIGHT = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "W3C Document Copyright");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_OASIS_OPEN_LICENSE = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "OASIS Open License");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_MODIFIED_BSD_LICENSE = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "Modified BSD License");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_APACHE_LICENSE_VERSION_2_0 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "Apache License Version 2.0");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_GPL_VERSION_1 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "GNU General Public License, version 1");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_GPL_VERSION_2 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "GNU General Public License, version 2");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_GPL_VERSION_3 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "GNU General Public License, version 3");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_MIT = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "The MIT License");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_CDDL1 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "COMMON DEVELOPMENT AND DISTRIBUTION LICENSE Version 1.0");
    @Deprecated
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_ACADEMIC_FREE_LICENSE_VERSION_2_1 = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "Academic Free License, Version 2.1");
    public static final Datum RAT_LICENSE_FAMILY_NAME_DATUM_UNKNOWN = new Datum("http://org/apache/rat/meta-data#LicenseFamilyName", "?????");
    public static final String RAT_URL_HEADER_SAMPLE = "http://org/apache/rat/meta-data#HeaderSample";
    public static final String RAT_URL_APPROVED_LICENSE = "http://org/apache/rat/meta-data#ApprovedLicense";
    public static final String RAT_APPROVED_LICENSE_VALUE_TRUE = Boolean.TRUE.toString();
    public static final String RAT_APPROVED_LICENSE_VALUE_FALSE = Boolean.FALSE.toString();
    public static final Datum RAT_APPROVED_LICENSE_DATUM_TRUE = new Datum("http://org/apache/rat/meta-data#ApprovedLicense", RAT_APPROVED_LICENSE_VALUE_TRUE);
    public static final Datum RAT_APPROVED_LICENSE_DATUM_FALSE = new Datum("http://org/apache/rat/meta-data#ApprovedLicense", RAT_APPROVED_LICENSE_VALUE_FALSE);
    @Deprecated
    public static final Datum RAT_APPROVED_LICENSE_DATIM_TRUE = RAT_APPROVED_LICENSE_DATUM_TRUE;
    @Deprecated
    public static final Datum RAT_APPROVED_LICENSE_DATIM_FALSE = RAT_APPROVED_LICENSE_DATUM_FALSE;
    private final List<Datum> data = new ArrayList<Datum>(16);

    public void reportOnLicense(ILicense license) {
        if (StringUtils.isNotBlank((CharSequence)license.getNotes())) {
            this.set(new Datum(RAT_URL_HEADER_SAMPLE, license.getNotes()));
        }
        this.set(new Datum(RAT_URL_HEADER_CATEGORY, license.getLicenseFamily().getFamilyCategory()));
        this.set(new Datum(RAT_URL_LICENSE_FAMILY_CATEGORY, license.getLicenseFamily().getFamilyCategory()));
        this.set(new Datum(RAT_URL_LICENSE_FAMILY_NAME, license.getLicenseFamily().getFamilyName()));
    }

    public Collection<Datum> getData() {
        return Collections.unmodifiableCollection(this.data);
    }

    public void add(Datum datum) {
        this.data.add(datum);
    }

    public void set(Datum datum) {
        this.clear(datum.getName());
        this.add(datum);
    }

    public Datum get(String name) {
        Datum result = null;
        for (Datum next : this.data) {
            if (!name.equals(next.getName())) continue;
            result = next;
            break;
        }
        return result;
    }

    public String value(String name) {
        Datum datum = this.get(name);
        String result = datum == null ? null : datum.getValue();
        return result;
    }

    public boolean clear(String name) {
        boolean dataRemoved = false;
        Iterator<Datum> it = this.data.iterator();
        while (it.hasNext()) {
            Datum datum = it.next();
            if (!datum.getName().equals(name)) continue;
            it.remove();
            dataRemoved = true;
        }
        return dataRemoved;
    }

    public void clear() {
        this.data.clear();
    }

    public static final class Datum {
        private final String name;
        private final String value;

        public Datum(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Datum [ name ='" + this.name + "',value ='" + this.value + " ']";
        }
    }
}

