/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.matchers.FullTextMatcher;
import org.apache.rat.analysis.matchers.SimpleTextMatcher;
import org.apache.rat.configuration.LicenseReader;
import org.apache.rat.configuration.MatcherBuilderTracker;
import org.apache.rat.configuration.MatcherReader;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.configuration.builders.ChildContainerBuilder;
import org.apache.rat.configuration.builders.MatcherRefBuilder;
import org.apache.rat.configuration.builders.TextCaptureBuilder;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseFamilySetFactory;
import org.apache.rat.license.LicenseSetFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLConfigurationReader
implements LicenseReader,
MatcherReader {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_DERIVED_FROM = "derived_from";
    private static final String ATT_LICENSE_REF = "license_ref";
    private static final String ATT_CLASS_NAME = "class";
    private static final String ROOT = "rat-config";
    private static final String FAMILIES = "families";
    private static final String LICENSES = "licenses";
    private static final String LICENSE = "license";
    private static final String APPROVED = "approved";
    private static final String FAMILY = "family";
    private static final String NOTE = "note";
    private static final String MATCHERS = "matchers";
    private static final String MATCHER = "matcher";
    private Document document;
    private final Element rootElement;
    private final Element familiesElement;
    private final Element licensesElement;
    private final Element approvedElement;
    private final Element matchersElement;
    private final SortedSet<ILicense> licenses;
    private final Map<String, IHeaderMatcher> matchers;
    private final SortedSet<ILicenseFamily> licenseFamilies;
    private final SortedSet<String> approvedFamilies;

    public XMLConfigurationReader() {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No XML parser defined", e);
        }
        this.rootElement = this.document.createElement(ROOT);
        this.document.appendChild(this.rootElement);
        this.familiesElement = this.document.createElement(FAMILIES);
        this.rootElement.appendChild(this.familiesElement);
        this.licensesElement = this.document.createElement(LICENSES);
        this.rootElement.appendChild(this.licensesElement);
        this.approvedElement = this.document.createElement(APPROVED);
        this.rootElement.appendChild(this.approvedElement);
        this.matchersElement = this.document.createElement(MATCHERS);
        this.rootElement.appendChild(this.matchersElement);
        this.licenses = LicenseSetFactory.emptyLicenseSet();
        this.licenseFamilies = LicenseFamilySetFactory.emptyLicenseFamilySet();
        this.approvedFamilies = new TreeSet<String>();
        this.matchers = new HashMap<String, IHeaderMatcher>();
    }

    @Override
    public void addLicenses(URL url) {
        this.read(url);
    }

    public void read(URL ... urls) {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create DOM builder", e);
        }
        for (URL url : urls) {
            try {
                this.add(builder.parse(url.openStream()));
            }
            catch (IOException | SAXException e) {
                throw new ConfigurationException("Unable to read url: " + url, e);
            }
        }
    }

    private void nodeListConsumer(NodeList list, Consumer<Node> consumer) {
        for (int i = 0; i < list.getLength(); ++i) {
            consumer.accept(list.item(i));
        }
    }

    public void add(Document newDoc) {
        this.nodeListConsumer(newDoc.getElementsByTagName(FAMILIES), nl -> this.nodeListConsumer(nl.getChildNodes(), n -> this.familiesElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true)))));
        this.nodeListConsumer(newDoc.getElementsByTagName(LICENSE), n -> this.licensesElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true))));
        this.nodeListConsumer(newDoc.getElementsByTagName(APPROVED), nl -> this.nodeListConsumer(nl.getChildNodes(), n -> this.approvedElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true)))));
        this.nodeListConsumer(newDoc.getElementsByTagName(MATCHERS), n -> this.matchersElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true))));
    }

    private Map<String, String> attributes(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            result.put(n.getNodeName(), n.getNodeValue());
        }
        return result;
    }

    public static IHeaderMatcher createTextMatcher(String id, String txt) {
        boolean complex = txt.contains(" ") | txt.contains("\\t") | txt.contains("\\n") | txt.contains("\\r") | txt.contains("\\f") | txt.contains("\\v");
        return complex ? new FullTextMatcher(id, txt) : new SimpleTextMatcher(id, txt);
    }

    private AbstractBuilder parseMatcher(Node matcherNode) {
        AbstractBuilder builder = MatcherBuilderTracker.getMatcherBuilder(matcherNode.getNodeName());
        NamedNodeMap nnm = matcherNode.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            String methodName = "set" + StringUtils.capitalize((String)n.getNodeName());
            try {
                MethodUtils.invokeExactMethod((Object)builder, (String)methodName, (Object)n.getNodeValue());
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(String.format("'%s' does not have a setter '%s' that takes a String argument", matcherNode.getNodeName(), methodName));
            }
            catch (IllegalAccessException | InvocationTargetException | DOMException e) {
                throw new ConfigurationException(e);
            }
        }
        if (builder instanceof ChildContainerBuilder) {
            ChildContainerBuilder ccb = (ChildContainerBuilder)builder;
            this.nodeListConsumer(matcherNode.getChildNodes(), x -> {
                if (x.getNodeType() == 1) {
                    ccb.add(this.parseMatcher((Node)x));
                }
            });
        }
        if (builder instanceof TextCaptureBuilder) {
            ((TextCaptureBuilder)((Object)builder)).setText(matcherNode.getTextContent().trim());
        }
        if (builder instanceof MatcherRefBuilder) {
            ((MatcherRefBuilder)builder).setMatchers(this.matchers);
        }
        if (builder.hasId()) {
            builder = new DelegatingBuilder(builder){

                @Override
                public IHeaderMatcher build() {
                    IHeaderMatcher result = this.delegate.build();
                    XMLConfigurationReader.this.matchers.put(result.getId(), result);
                    return result;
                }
            };
        }
        return builder;
    }

    private ILicense parseLicense(Node licenseNode) {
        Map<String, String> attributes = this.attributes(licenseNode);
        ILicense.Builder builder = ILicense.builder();
        builder.setLicenseFamilyCategory(attributes.get(FAMILY));
        builder.setName(attributes.get(ATT_NAME));
        builder.setId(attributes.get(ATT_ID));
        StringBuilder notesBuilder = new StringBuilder();
        this.nodeListConsumer(licenseNode.getChildNodes(), x -> {
            if (x.getNodeType() == 1) {
                if (x.getNodeName().equals(NOTE)) {
                    notesBuilder.append(x.getTextContent()).append("\n");
                } else {
                    builder.setMatcher(this.parseMatcher((Node)x));
                }
            }
        });
        builder.setDerivedFrom((String)StringUtils.defaultIfBlank((CharSequence)attributes.get(ATT_DERIVED_FROM), null));
        builder.setNotes((String)StringUtils.defaultIfBlank((CharSequence)notesBuilder.toString().trim(), null));
        return builder.build(this.licenseFamilies);
    }

    @Override
    public SortedSet<ILicense> readLicenses() {
        this.readFamilies();
        this.readMatcherBuilders();
        if (this.licenses.isEmpty()) {
            this.nodeListConsumer(this.document.getElementsByTagName(LICENSE), x -> this.licenses.add(this.parseLicense((Node)x)));
            this.document = null;
        }
        return Collections.unmodifiableSortedSet(this.licenses);
    }

    @Override
    public SortedSet<ILicenseFamily> readFamilies() {
        if (this.licenseFamilies.isEmpty()) {
            this.nodeListConsumer(this.document.getElementsByTagName(FAMILIES), x -> this.nodeListConsumer(x.getChildNodes(), this::parseFamily));
            this.nodeListConsumer(this.document.getElementsByTagName(APPROVED), x -> this.nodeListConsumer(x.getChildNodes(), this::parseApproved));
        }
        return Collections.unmodifiableSortedSet(this.licenseFamilies);
    }

    private ILicenseFamily parseFamily(Map<String, String> attributes) {
        if (attributes.containsKey(ATT_ID)) {
            ILicenseFamily.Builder builder = ILicenseFamily.builder();
            builder.setLicenseFamilyCategory(attributes.get(ATT_ID));
            builder.setLicenseFamilyName((String)StringUtils.defaultIfBlank((CharSequence)attributes.get(ATT_NAME), (CharSequence)attributes.get(ATT_ID)));
            return builder.build();
        }
        return null;
    }

    private void parseFamily(Node familyNode) {
        if (FAMILY.equals(familyNode.getNodeName())) {
            ILicenseFamily result = this.parseFamily(this.attributes(familyNode));
            if (result == null) {
                throw new ConfigurationException(String.format("families/family tag requires %s attribute", ATT_ID));
            }
            this.licenseFamilies.add(result);
        }
    }

    private void parseApproved(Node approvedNode) {
        if (FAMILY.equals(approvedNode.getNodeName())) {
            Map<String, String> attributes = this.attributes(approvedNode);
            if (attributes.containsKey(ATT_LICENSE_REF)) {
                this.approvedFamilies.add(attributes.get(ATT_LICENSE_REF));
            } else if (attributes.containsKey(ATT_ID)) {
                ILicenseFamily target = this.parseFamily(attributes);
                this.licenseFamilies.add(target);
                this.approvedFamilies.add(target.getFamilyCategory());
            } else {
                throw new ConfigurationException(String.format("family tag requires %s or %s attribute", ATT_LICENSE_REF, ATT_ID));
            }
        }
    }

    @Override
    public SortedSet<String> approvedLicenseId() {
        if (this.licenses.isEmpty()) {
            this.readLicenses();
        }
        if (this.approvedFamilies.isEmpty()) {
            TreeSet<String> result = new TreeSet<String>();
            this.licenses.stream().map(x -> x.getLicenseFamily().getFamilyCategory()).forEach(result::add);
            return result;
        }
        return Collections.unmodifiableSortedSet(this.approvedFamilies);
    }

    private void parseMatcherBuilder(Node classNode) {
        Map<String, String> attributes = this.attributes(classNode);
        if (attributes.get(ATT_CLASS_NAME) == null) {
            throw new ConfigurationException("matcher must have a class attribute");
        }
        MatcherBuilderTracker.addBuilder(attributes.get(ATT_CLASS_NAME), attributes.get(ATT_NAME));
    }

    @Override
    public void readMatcherBuilders() {
        this.nodeListConsumer(this.document.getElementsByTagName(MATCHER), this::parseMatcherBuilder);
    }

    @Override
    public void addMatchers(URL url) {
        this.read(url);
    }

    static abstract class DelegatingBuilder
    extends AbstractBuilder {
        protected final AbstractBuilder delegate;

        DelegatingBuilder(AbstractBuilder delegate) {
            this.delegate = delegate;
        }
    }
}

