/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.configuration.builders.AbstractBuilder;

public abstract class ChildContainerBuilder
extends AbstractBuilder {
    protected final List<IHeaderMatcher.Builder> children = new ArrayList<IHeaderMatcher.Builder>();

    protected ChildContainerBuilder() {
    }

    public AbstractBuilder setResource(String resourceName) {
        ChildContainerBuilder childContainerBuilder;
        block9: {
            URL url = this.getClass().getResource(resourceName);
            InputStream in = url.openStream();
            try {
                String txt;
                BufferedReader buffer = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                while (null != (txt = buffer.readLine())) {
                    if (!StringUtils.isNotBlank((CharSequence)(txt = txt.trim()))) continue;
                    this.children.add(IHeaderMatcher.Builder.text().setText(txt));
                }
                childContainerBuilder = this;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigurationException("Unable to read matching text file: " + resourceName, e);
                }
            }
            in.close();
        }
        return childContainerBuilder;
    }

    public AbstractBuilder add(IHeaderMatcher.Builder child) {
        this.children.add(child);
        return this;
    }

    public AbstractBuilder add(Collection<IHeaderMatcher.Builder> children) {
        this.children.addAll(children);
        return this;
    }

    public List<IHeaderMatcher> getChildren() {
        return this.children.stream().map(IHeaderMatcher.Builder::build).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(":");
        this.children.stream().map(Object::toString).forEach(x -> sb.append("\n").append((String)x));
        return sb.toString();
    }
}

