/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.util.Map;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.configuration.builders.AbstractBuilder;

public class MatcherRefBuilder
extends AbstractBuilder {
    private String referenceId;
    private Map<String, IHeaderMatcher> matchers;

    public MatcherRefBuilder setRefId(String refId) {
        this.referenceId = refId;
        return this;
    }

    public MatcherRefBuilder setMatchers(Map<String, IHeaderMatcher> matchers) {
        this.matchers = matchers;
        return this;
    }

    @Override
    public IHeaderMatcher build() {
        IHeaderMatcher result = this.matchers.get(this.referenceId);
        return result != null ? result : new IHeaderMatcherProxy(this.referenceId, this.matchers);
    }

    @Override
    public String toString() {
        return "MathcerRefBuilder: " + this.referenceId;
    }

    private class IHeaderMatcherProxy
    implements IHeaderMatcher {
        private final String proxyId;
        private IHeaderMatcher wrapped;
        private Map<String, IHeaderMatcher> matchers;

        private IHeaderMatcherProxy(String proxyId, Map<String, IHeaderMatcher> matchers) {
            this.proxyId = proxyId;
            this.matchers = matchers;
        }

        private void checkProxy() {
            if (this.wrapped == null) {
                this.wrapped = this.matchers.get(this.proxyId);
                if (this.wrapped == null) {
                    throw new IllegalStateException(String.format("%s is not a valid matcher id", this.proxyId));
                }
                this.matchers = null;
            }
        }

        @Override
        public String getId() {
            this.checkProxy();
            return this.wrapped.getId();
        }

        @Override
        public void reset() {
            this.checkProxy();
            this.wrapped.reset();
        }

        @Override
        public IHeaderMatcher.State matches(String line) {
            this.checkProxy();
            return this.wrapped.matches(line);
        }

        @Override
        public IHeaderMatcher.State currentState() {
            this.checkProxy();
            return this.wrapped.currentState();
        }

        @Override
        public IHeaderMatcher.State finalizeState() {
            this.checkProxy();
            return this.wrapped.finalizeState();
        }
    }
}

