/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;

public class LicenseFamilySetFactory {
    private final SortedSet<ILicenseFamily> families;
    private final Collection<String> approvedLicenses;

    public LicenseFamilySetFactory(SortedSet<ILicenseFamily> licenses, Collection<String> approvedLicenses) {
        this.families = licenses;
        this.approvedLicenses = approvedLicenses;
    }

    public static SortedSet<ILicenseFamily> emptyLicenseFamilySet() {
        return new TreeSet<ILicenseFamily>();
    }

    public SortedSet<ILicenseFamily> getFamilies(LicenseSetFactory.LicenseFilter filter) {
        switch (filter) {
            case all: {
                return Collections.unmodifiableSortedSet(this.families);
            }
            case approved: {
                SortedSet<ILicenseFamily> result = LicenseFamilySetFactory.emptyLicenseFamilySet();
                this.families.stream().filter(x -> this.approvedLicenses.contains(x.getFamilyCategory())).forEach(result::add);
                return result;
            }
        }
        return Collections.emptySortedSet();
    }

    public SortedSet<String> getFamilyIds(LicenseSetFactory.LicenseFilter filter) {
        TreeSet<String> result = new TreeSet<String>();
        switch (filter) {
            case all: {
                this.families.stream().map(ILicenseFamily::getFamilyCategory).forEach(result::add);
                break;
            }
            case approved: {
                result.addAll(this.approvedLicenses);
                break;
            }
        }
        return result;
    }

    public static ILicenseFamily search(String target, SortedSet<ILicenseFamily> licenseFamilies) {
        ILicenseFamily family = ILicenseFamily.builder().setLicenseFamilyCategory(target).setLicenseFamilyName("Searching family").build();
        return LicenseFamilySetFactory.search(family, licenseFamilies);
    }

    public static ILicenseFamily search(ILicenseFamily target, SortedSet<ILicenseFamily> licenseFamilies) {
        SortedSet<ILicenseFamily> part = licenseFamilies.tailSet(target);
        return !part.isEmpty() && part.first().compareTo(target) == 0 ? part.first() : null;
    }
}

