/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import org.apache.commons.lang3.StringUtils;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.analysis.matchers.AbstractHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;

@ConfigComponent(type=ComponentType.MATCHER, name="text", desc="Matches the enclosed text")
public class SimpleTextMatcher
extends AbstractHeaderMatcher {
    @ConfigComponent(type=ComponentType.PARAMETER, name="simpleText", desc="The text to match", required=true)
    private final String simpleText;

    public SimpleTextMatcher(String simpleText) {
        this(null, simpleText);
    }

    public SimpleTextMatcher(String id, String simpleText) {
        super(id);
        if (StringUtils.isBlank((CharSequence)simpleText)) {
            throw new IllegalArgumentException("Simple text may not be null, empty or blank");
        }
        this.simpleText = simpleText;
    }

    public String getSimpleText() {
        return this.simpleText;
    }

    @Override
    public boolean matches(IHeaders headers) {
        return headers.raw().contains(this.simpleText);
    }
}

