/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.fileProcessors.AbstractFileProcessorBuilder;
import org.apache.rat.config.exclusion.fileProcessors.BazaarIgnoreBuilder;
import org.apache.rat.config.exclusion.fileProcessors.CVSIgnoreBuilder;
import org.apache.rat.config.exclusion.fileProcessors.GitIgnoreBuilder;
import org.apache.rat.config.exclusion.fileProcessors.HgIgnoreBuilder;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.utils.ExtendedIterator;

public enum StandardCollection {
    ALL("All of the Standard Excludes combined.", null, null, null),
    ARCH("The files and directories created by an ARCH source code control based tool.", Collections.singletonList("**/.arch-ids/**"), null, null),
    BAZAAR("The files and directories created by a Bazaar source code control based tool.", Arrays.asList("**/.bzr/**", "**/.bzrignore"), null, new BazaarIgnoreBuilder()),
    BITKEEPER("The files and directories created by a Bitkeeper source code control based tool.", Arrays.asList("**/BitKeeper/**", "**/ChangeSet/**"), null, null),
    CVS("The files and directories created by a CVS source code control based tool.", Arrays.asList("**/.cvsignore", "**/RCS/**", "**/SCCS/**", "**/CVS/**", "**/CVS.adm/**", "**/RCSLOG/**", "**/cvslog.*", "**/tags/**", "**/TAGS/**", "**/.make.state", "**/.nse_depinfo", "**/*~", "**/#*", "**/.#*", "**/,*", "**/_$*", "**/*$", "**/*.old", "**/*.bak", "**/*.BAK", "**/*.orig", "**/*.rej", "**/.del-*", "**/*.a", "**/*.old", "**/*.o", "**/*.obj", "**/*.so", "**/*.exe", "**/*.Z", "**/*.elc", "**/*.ln", "**/core"), null, new CVSIgnoreBuilder()),
    DARCS("The files and directories created by a DARCS source code control based tool.", Arrays.asList("**/_darcs/**", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"), null, null),
    ECLIPSE("The files and directories created by an Eclipse IDE based tool.", Arrays.asList("**/.checkstyle", "**/.classpath", "**/.factorypath", "**/.project", "**/.settings/**", "**/.externalToolBuilders"), null, null),
    GIT("The files and directories created by GIT source code control to support GIT, also processes files listed in '.gitignore' and (unless RAT_NO_GIT_GLOBAL_IGNORE is specified) the global gitignore.", Arrays.asList("**/.git/**", "**/.gitignore"), null, new GitIgnoreBuilder()),
    HIDDEN_DIR("The hidden directories. Directories with names that start with '.'", null, new DocumentNameMatcher("HIDDEN_DIR", new Predicate<DocumentName>(){

        @Override
        public boolean test(DocumentName documentName) {
            File file = documentName.asFile();
            return file.isDirectory() && ExclusionUtils.isHidden(documentName.getShortName());
        }

        public String toString() {
            return "HIDDEN_DIR";
        }
    }), null),
    HIDDEN_FILE("The hidden files. Directories with names that start with '.'", null, new DocumentNameMatcher("HIDDEN_FILE", new Predicate<DocumentName>(){

        @Override
        public boolean test(DocumentName documentName) {
            File file = documentName.asFile();
            return file.isFile() && ExclusionUtils.isHidden(documentName.getShortName());
        }

        public String toString() {
            return "HIDDEN_FILE";
        }
    }), null),
    IDEA("The files and directories created by an IDEA IDE based tool.", Arrays.asList("**/*.iml", "**/*.ipr", "**/*.iws", "**/.idea/**"), null, null),
    MAC("The .DS_Store files on Mac computers.", Collections.singletonList("**/.DS_Store"), null, null),
    MAVEN("The files and directories created by Maven build system based project.", Arrays.asList("**/target/**", "**/cobertura.ser", "**/MANIFEST.MF", "**/release.properties", "**/.repository", "**/build.log", "**/.mvn/**", "**/pom.xml.releaseBackup"), null, null),
    MERCURIAL("The files and directories created by a Mercurial source code control based tool.", Arrays.asList("**/.hg/**", "**/.hgignore"), null, new HgIgnoreBuilder()),
    MISC("The set of miscellaneous files generally left by editors and the like.", Arrays.asList("**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*"), null, null),
    MKS("The files and directories created by an MKS source code control based tool.", Collections.singletonList("**/project.pj"), null, null),
    RCS("The files and directories created by a RCS source code control based tool.", Collections.singletonList("**/RCS/**"), null, null),
    SCCS("The files and directories created by a SCCS source code control based tool.", Collections.singletonList("**/SCCS/**"), null, null),
    SERENA_DIMENSIONS_10("The files and directories created by a Serena Dimensions V10 change control system based tool.", Collections.singletonList("**/.metadata/**"), null, null),
    STANDARD_PATTERNS("A standard collection of generally accepted patterns to ignore.", null, null, null),
    STANDARD_SCMS("A standard collection of SCMs", null, null, null),
    SUBVERSION("The files and directories created by a Subversion source code control based tool.", Collections.singletonList("**/.svn/**"), null, null),
    SURROUND_SCM("The files and directories created by a Surround SCM source code control based tool.", Collections.singletonList("**/.MySCMServerInfo"), null, null),
    VSS("The files and directories created by a Visual Source Safe source code control based tool.", Collections.singletonList("**/vssver.scc"), null, null);

    private final Collection<String> patterns;
    private final DocumentNameMatcher staticDocumentNameMatcher;
    private final AbstractFileProcessorBuilder fileProcessorBuilder;
    private final String desc;

    private StandardCollection(String desc, Collection<String> patterns, DocumentNameMatcher documentNameMatcher, AbstractFileProcessorBuilder fileProcessorBuilder) {
        this.desc = desc;
        this.patterns = patterns == null ? Collections.emptyList() : new HashSet<String>(patterns);
        this.staticDocumentNameMatcher = documentNameMatcher;
        this.fileProcessorBuilder = fileProcessorBuilder;
    }

    public String desc() {
        return this.desc;
    }

    private Set<StandardCollection> getCollections() {
        HashSet<StandardCollection> result = new HashSet<StandardCollection>();
        switch (this) {
            case ALL: {
                for (StandardCollection sc : StandardCollection.values()) {
                    if (sc == ALL) continue;
                    result.add(sc);
                }
                break;
            }
            case STANDARD_PATTERNS: {
                result.addAll(Arrays.asList(MISC, CVS, RCS, SCCS, VSS, MKS, SUBVERSION, ARCH, BAZAAR, SURROUND_SCM, MAC, SERENA_DIMENSIONS_10, MERCURIAL, GIT, BITKEEPER, DARCS));
                break;
            }
            case STANDARD_SCMS: {
                result.addAll(Arrays.asList(SUBVERSION, GIT, BAZAAR, MERCURIAL, CVS));
                break;
            }
            default: {
                result.add(this);
            }
        }
        return result;
    }

    public Set<String> patterns() {
        HashSet<String> result = new HashSet<String>();
        this.getCollections().forEach(sc -> result.addAll(sc.patterns));
        return result;
    }

    public ExtendedIterator<AbstractFileProcessorBuilder> fileProcessorBuilder() {
        ArrayList<AbstractFileProcessorBuilder> lst = new ArrayList<AbstractFileProcessorBuilder>();
        for (StandardCollection sc : this.getCollections()) {
            if (sc.fileProcessorBuilder == null) continue;
            lst.add(sc.fileProcessorBuilder);
        }
        return ExtendedIterator.create(lst.iterator());
    }

    public DocumentNameMatcher staticDocumentNameMatcher() {
        ArrayList<DocumentNameMatcher> lst = new ArrayList<DocumentNameMatcher>();
        for (StandardCollection sc : this.getCollections()) {
            if (sc.staticDocumentNameMatcher == null) continue;
            lst.add(sc.staticDocumentNameMatcher);
        }
        if (lst.isEmpty()) {
            return null;
        }
        if (lst.size() == 1) {
            return (DocumentNameMatcher)lst.get(0);
        }
        return new DocumentNameMatcher(this.name() + " static DocumentNameMatchers", DocumentNameMatcher.or(lst));
    }

    public boolean hasStaticDocumentNameMatcher() {
        for (StandardCollection sc : this.getCollections()) {
            if (sc.staticDocumentNameMatcher == null) continue;
            return true;
        }
        return false;
    }
}

