/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.parameters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.BuilderParams;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;
import org.apache.rat.utils.DefaultLog;

public class Description {
    private final ComponentType type;
    private final String name;
    private final String desc;
    private final Class<?> childClass;
    private final boolean isCollection;
    private final boolean required;
    private final Map<String, Description> children;

    public Description(ComponentType type, String name, String desc, boolean isCollection, Class<?> childClass, Collection<Description> children, boolean required) {
        this.type = type;
        this.name = name;
        this.desc = desc;
        this.isCollection = isCollection;
        this.required = required;
        if (type == ComponentType.BUILD_PARAMETER) {
            Method m;
            try {
                m = BuilderParams.class.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new ConfigurationException(String.format("'%s' is not a valid BuildParams method", name));
            }
            this.childClass = m.getReturnType();
        } else {
            this.childClass = childClass;
        }
        this.children = new TreeMap<String, Description>();
        if (children != null) {
            children.forEach(d -> this.children.put(d.name, (Description)d));
        }
    }

    public Description(ConfigComponent configComponent, boolean isCollection, Class<?> childClass, Collection<Description> children) {
        this(configComponent.type(), configComponent.name(), configComponent.desc(), isCollection, childClass, children, configComponent.required());
    }

    public boolean isRequired() {
        return this.required;
    }

    public ComponentType getType() {
        return this.type;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Class<?> getChildType() {
        return this.childClass;
    }

    public String getCommonName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getParamValue(Object object) {
        if (this.isCollection) {
            return null;
        }
        try {
            Object val = this.getter(object.getClass()).invoke(object, new Object[0]);
            return val == null ? null : val.toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DefaultLog.getInstance().error(String.format("Can not retrieve value for '%s' from %s%n", this.name, object.getClass().getName()), e);
            return null;
        }
    }

    public Map<String, Description> getChildren() {
        return this.children;
    }

    public Collection<Description> childrenOfType(ComponentType type) {
        return this.filterChildren(d -> d.getType() == type);
    }

    public Collection<Description> filterChildren(Predicate<Description> filter) {
        return this.children.values().stream().filter(filter).collect(Collectors.toList());
    }

    public String methodName(String prefix) {
        return prefix + StringUtils.capitalize((String)this.name);
    }

    public Method getter(Class<?> clazz) throws NoSuchMethodException, SecurityException {
        return clazz.getMethod(this.methodName("get"), new Class[0]);
    }

    public Method setter(Class<?> clazz) throws NoSuchMethodException, SecurityException {
        String methodName = this.methodName(this.isCollection ? "add" : "set");
        switch (this.type) {
            case LICENSE: {
                throw new NoSuchMethodException("Can not set a License as a child");
            }
            case MATCHER: {
                return clazz.getMethod(methodName, IHeaderMatcher.Builder.class);
            }
            case PARAMETER: {
                return clazz.getMethod(methodName, IHeaderMatcher.class.isAssignableFrom(this.childClass) ? IHeaderMatcher.Builder.class : this.childClass);
            }
            case BUILD_PARAMETER: {
                return clazz.getMethod(methodName, this.childClass);
            }
        }
        throw new IllegalStateException("Type " + (Object)((Object)this.type) + " not valid.");
    }

    private void callSetter(Description description, IHeaderMatcher.Builder builder, String value) {
        try {
            description.setter(builder.getClass()).invoke((Object)builder, value);
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("No setter for '%s' on %s", description.getCommonName(), builder.getClass().getCanonicalName());
            DefaultLog.getInstance().error(msg);
            throw new ConfigurationException(msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            String msg = String.format("Unable to call setter for '%s' on %s", description.getCommonName(), builder.getClass().getCanonicalName());
            DefaultLog.getInstance().error(msg, e);
            throw new ConfigurationException(msg, e);
        }
    }

    public void setChildren(IHeaderMatcher.Builder builder, Map<String, String> attributes) {
        attributes.forEach((key, value) -> this.setChild(builder, (String)key, (String)value));
    }

    public void setChild(IHeaderMatcher.Builder builder, String name, String value) {
        Description d = this.getChildren().get(name);
        if (d == null) {
            DefaultLog.getInstance().error(String.format("%s does not define a ConfigComponent for a member %s.", builder.getClass().getCanonicalName(), name));
        } else {
            this.callSetter(d, builder, value);
        }
    }

    public String toString() {
        String childList = this.children.isEmpty() ? "" : this.children.values().stream().map(Description::getCommonName).collect(Collectors.joining(", "));
        return String.format("Description[%s t:%s c:%s %s children: [%s]] ", new Object[]{this.name, this.type, this.isCollection, this.childClass, childList});
    }
}

