/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.results;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.utils.DefaultLog;

public final class ClaimValidator {
    private final ConcurrentHashMap<ClaimStatistic.Counter, Integer> max = new ConcurrentHashMap();
    private final ConcurrentHashMap<ClaimStatistic.Counter, Integer> min = new ConcurrentHashMap();
    private boolean hasErrors;

    public ClaimValidator() {
        for (ClaimStatistic.Counter counter : ClaimStatistic.Counter.values()) {
            this.max.put(counter, counter.getDefaultMaxValue() < 0 ? Integer.MAX_VALUE : counter.getDefaultMaxValue());
            this.min.put(counter, counter.getDefaultMinValue());
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void setMax(ClaimStatistic.Counter counter, int value) {
        if (value < 0) {
            this.max.put(counter, Integer.MAX_VALUE);
        } else {
            this.max.put(counter, value);
        }
        this.min.compute(counter, (k, v) -> v != null && v > this.max.get(k) ? this.max.get(k) : v);
    }

    public void setMin(ClaimStatistic.Counter counter, int value) {
        this.min.put(counter, value);
        this.max.compute(counter, (k, v) -> v == null || v < value ? value : v);
    }

    public int getMax(ClaimStatistic.Counter counter) {
        Integer result = this.max.get((Object)counter);
        return result == null ? 0 : result;
    }

    public int getMin(ClaimStatistic.Counter counter) {
        Integer result = this.min.get((Object)counter);
        return result == null ? 0 : result;
    }

    public boolean isValid(ClaimStatistic.Counter counter, int count) {
        boolean result = this.max.get((Object)counter) >= count && this.min.get((Object)counter) <= count;
        this.hasErrors |= !result;
        return result;
    }

    public void logIssues(ClaimStatistic statistic) {
        for (ClaimStatistic.Counter counter : ClaimStatistic.Counter.values()) {
            if (this.isValid(counter, statistic.getCounter(counter))) continue;
            DefaultLog.getInstance().error(String.format("Unexpected count for %s, limit is [%s,%s].  Count: %s", new Object[]{counter, this.min.get((Object)counter), this.max.get((Object)counter), statistic.getCounter(counter)}));
            DefaultLog.getInstance().info(String.format("%s (%s) is %s", new Object[]{counter, counter.displayName(), StringUtils.uncapitalize((String)counter.getDescription())}));
        }
    }

    public List<String> listIssues(ClaimStatistic statistic) {
        ArrayList<String> result = new ArrayList<String>();
        for (ClaimStatistic.Counter counter : ClaimStatistic.Counter.values()) {
            if (this.isValid(counter, statistic.getCounter(counter))) continue;
            result.add(counter.toString());
        }
        return result;
    }
}

