/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rat.BuilderParams;
import org.apache.rat.ConfigurationException;
import org.apache.rat.ImplementationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.config.parameters.DescriptionBuilder;
import org.apache.rat.configuration.LicenseReader;
import org.apache.rat.configuration.MatcherBuilderTracker;
import org.apache.rat.configuration.MatcherReader;
import org.apache.rat.configuration.XMLConfig;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.utils.DefaultLog;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLConfigurationReader
implements LicenseReader,
MatcherReader {
    private Document document;
    private final Element rootElement;
    private final Element familiesElement;
    private final Element licensesElement;
    private final Element approvedElement;
    private final Element matchersElement;
    private final SortedSet<ILicense> licenses;
    private final Map<String, IHeaderMatcher> matchers;
    private final BuilderParams builderParams;
    private final SortedSet<ILicenseFamily> licenseFamilies;
    private final SortedSet<String> approvedFamilies;

    public XMLConfigurationReader() {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No XML parser defined", e);
        }
        this.rootElement = this.document.createElement("rat-config");
        this.document.appendChild(this.rootElement);
        this.familiesElement = this.document.createElement("families");
        this.rootElement.appendChild(this.familiesElement);
        this.licensesElement = this.document.createElement("licenses");
        this.rootElement.appendChild(this.licensesElement);
        this.approvedElement = this.document.createElement("approved");
        this.rootElement.appendChild(this.approvedElement);
        this.matchersElement = this.document.createElement("matchers");
        this.rootElement.appendChild(this.matchersElement);
        this.licenses = new TreeSet<ILicense>();
        this.licenseFamilies = new TreeSet<ILicenseFamily>();
        this.approvedFamilies = new TreeSet<String>();
        this.matchers = new HashMap<String, IHeaderMatcher>();
        this.builderParams = new BuilderParams(){

            @Override
            public Map<String, IHeaderMatcher> matcherMap() {
                return XMLConfigurationReader.this.matchers;
            }

            @Override
            public SortedSet<ILicenseFamily> licenseFamilies() {
                return XMLConfigurationReader.this.licenseFamilies;
            }
        };
    }

    private String nodeText(Node node) {
        StringBuilder stringBuilder = new StringBuilder().append("<").append(node.getNodeName());
        NamedNodeMap attr = node.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            Node n = attr.item(i);
            stringBuilder.append(String.format(" %s='%s'", n.getNodeName(), n.getNodeValue()));
        }
        return stringBuilder.append(">").toString();
    }

    @Override
    public void addLicenses(URI uri) {
        this.read(uri);
    }

    public void read(Reader reader) {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create DOM builder", e);
        }
        try {
            this.add(builder.parse(new InputSource(reader)));
        }
        catch (IOException | SAXException e) {
            throw new ConfigurationException("Unable to read inputSource", e);
        }
    }

    public void read(URI ... uris) {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create DOM builder", e);
        }
        for (URI uri : uris) {
            try (InputStream inputStream = uri.toURL().openStream();){
                this.add(builder.parse(inputStream));
            }
            catch (IOException | SAXException e) {
                throw new ConfigurationException("Unable to read uri: " + uri, e);
            }
        }
    }

    private void nodeListConsumer(NodeList list, Consumer<Node> consumer) {
        for (int i = 0; i < list.getLength(); ++i) {
            consumer.accept(list.item(i));
        }
    }

    public void add(Document newDoc) {
        this.nodeListConsumer(newDoc.getElementsByTagName("families"), nl -> this.nodeListConsumer(nl.getChildNodes(), n -> this.familiesElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true)))));
        this.nodeListConsumer(newDoc.getElementsByTagName("license"), n -> this.licensesElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true))));
        this.nodeListConsumer(newDoc.getElementsByTagName("approved"), nl -> this.nodeListConsumer(nl.getChildNodes(), n -> this.approvedElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true)))));
        this.nodeListConsumer(newDoc.getElementsByTagName("matchers"), n -> this.matchersElement.appendChild(this.rootElement.getOwnerDocument().adoptNode(n.cloneNode(true))));
    }

    private Map<String, String> attributes(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            result.put(n.getNodeName(), n.getNodeValue());
        }
        return result;
    }

    private void callSetter(Description desc, IHeaderMatcher.Builder builder, Object value) {
        try {
            desc.setter(builder.getClass()).invoke((Object)builder, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    private void processBuilderParams(Description description, IHeaderMatcher.Builder builder) {
        for (Description desc : description.childrenOfType(ComponentType.BUILD_PARAMETER)) {
            Method m = this.builderParams.get(desc.getCommonName());
            try {
                this.callSetter(desc, builder, m.invoke((Object)this.builderParams, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw ImplementationException.makeInstance(e);
            }
        }
    }

    private void processChildren(Description description, List<Node> children, BiPredicate<Node, Description> childProcessor) {
        Iterator<Node> iter = children.iterator();
        while (iter.hasNext()) {
            Node child = iter.next();
            Description childDescription = description.getChildren().get(child.getNodeName());
            if (childDescription == null || !childProcessor.test(child, childDescription)) continue;
            iter.remove();
        }
    }

    private BiPredicate<Node, Description> matcherChildNodeProcessor(AbstractBuilder builder, Description description) {
        return (child, childDescription) -> {
            switch (childDescription.getType()) {
                case LICENSE: 
                case BUILD_PARAMETER: {
                    throw new ConfigurationException(String.format("%s may not be used as an enclosed matcher.  %s '%s' found in '%s'", new Object[]{childDescription.getType(), childDescription.getType(), childDescription.getCommonName(), description.getCommonName()}));
                }
                case MATCHER: {
                    AbstractBuilder b = this.parseMatcher((Node)child);
                    this.callSetter(b.getDescription(), builder, b);
                    return true;
                }
                case PARAMETER: {
                    if (!XMLConfig.isInlineNode(description.getCommonName(), childDescription.getCommonName()) || childDescription.getChildType() == String.class) {
                        this.callSetter((Description)childDescription, builder, child.getTextContent());
                    } else {
                        this.callSetter((Description)childDescription, builder, this.parseMatcher((Node)child));
                    }
                    return true;
                }
            }
            return false;
        };
    }

    private void setValue(Description description, Description childDescription, IHeaderMatcher.Builder builder, Node child) {
        if (childDescription.getChildType() == String.class) {
            this.callSetter(description, builder, child.getTextContent());
        } else {
            this.callSetter(description, builder, this.parseMatcher(child));
        }
    }

    private Pair<Boolean, List<Node>> processChildNodes(Description description, Node parent, BiPredicate<Node, Description> childProcessor) {
        try {
            boolean foundChildren = false;
            ArrayList<Node> children = new ArrayList<Node>();
            if (parent.hasChildNodes()) {
                this.nodeListConsumer(parent.getChildNodes(), n -> {
                    if (n.getNodeType() == 1) {
                        children.add((Node)n);
                    }
                });
                boolean bl = foundChildren = !children.isEmpty();
                if (foundChildren) {
                    this.processChildren(description, children, childProcessor);
                }
            }
            return new ImmutablePair((Object)foundChildren, children);
        }
        catch (RuntimeException exception) {
            DefaultLog.getInstance().error(String.format("Child node extraction error in: '%s'", this.nodeText(parent)));
            throw exception;
        }
    }

    private AbstractBuilder parseMatcher(Node matcherNode) {
        AbstractBuilder builder = MatcherBuilderTracker.getMatcherBuilder(matcherNode.getNodeName());
        try {
            Description description = DescriptionBuilder.buildMap(builder.getClass());
            if (description == null) {
                throw new ConfigurationException(String.format("Unable to build description for %s", builder.getClass()));
            }
            this.processBuilderParams(description, builder);
            description.setChildren(builder, this.attributes(matcherNode));
            Pair<Boolean, List<Node>> pair = this.processChildNodes(description, matcherNode, this.matcherChildNodeProcessor(builder, description));
            boolean foundChildren = (Boolean)pair.getLeft();
            List children = (List)pair.getRight();
            List childDescriptions = description.getChildren().values().stream().filter(d -> XMLConfig.isInlineNode(description.getCommonName(), d.getCommonName())).collect(Collectors.toList());
            for (Description childDescription : childDescriptions) {
                if (XMLConfig.isInlineNode(description.getCommonName(), childDescription.getCommonName())) {
                    if (childDescription.getChildType() == String.class) {
                        if (foundChildren) continue;
                        this.callSetter(childDescription, builder, matcherNode.getTextContent());
                        continue;
                    }
                    Iterator iter = children.iterator();
                    while (iter.hasNext()) {
                        Node child2 = (Node)iter.next();
                        this.callSetter(childDescription, builder, this.parseMatcher(child2));
                        iter.remove();
                    }
                    continue;
                }
                this.processChildren(description, children, (child, childD) -> {
                    if (childD.getChildType().equals(description.getChildType())) {
                        this.setValue(childDescription, (Description)childD, builder, (Node)child);
                        return true;
                    }
                    return false;
                });
            }
            if (!children.isEmpty()) {
                children.forEach(n -> DefaultLog.getInstance().warn(String.format("unrecognised child node '%s' in node '%s'%n", n.getNodeName(), matcherNode.getNodeName())));
            }
        }
        catch (DOMException e) {
            DefaultLog.getInstance().error(String.format("Matcher error in: '%s'", this.nodeText(matcherNode)));
            throw new ConfigurationException(e);
        }
        return builder.hasId() ? new IDRecordingBuilder(this.matchers, builder) : builder;
    }

    private BiPredicate<Node, Description> licenseChildNodeProcessor(ILicense.Builder builder, Description description) {
        return (child, childDescription) -> {
            switch (childDescription.getType()) {
                case LICENSE: {
                    throw new ConfigurationException(String.format("%s may not be enclosed in another license.  %s '%s' found in '%s'", new Object[]{childDescription.getType(), childDescription.getType(), childDescription.getCommonName(), description.getCommonName()}));
                }
                case BUILD_PARAMETER: {
                    break;
                }
                case MATCHER: {
                    AbstractBuilder b = this.parseMatcher((Node)child);
                    this.callSetter(b.getDescription(), builder, b);
                    return true;
                }
                case PARAMETER: {
                    if (!XMLConfig.isLicenseChild(childDescription.getCommonName()) || childDescription.getChildType() == String.class) {
                        this.callSetter((Description)childDescription, builder, child.getTextContent());
                    } else {
                        this.callSetter((Description)childDescription, builder, this.parseMatcher((Node)child));
                    }
                    return true;
                }
            }
            return false;
        };
    }

    private ILicense parseLicense(Node licenseNode) {
        try {
            ILicense.Builder builder = ILicense.builder();
            Description description = builder.getDescription();
            this.processBuilderParams(description, builder);
            description.setChildren(builder, this.attributes(licenseNode));
            Pair<Boolean, List<Node>> pair = this.processChildNodes(description, licenseNode, this.licenseChildNodeProcessor(builder, description));
            List children = (List)pair.getRight();
            List childDescriptions = description.getChildren().values().stream().filter(d -> XMLConfig.isLicenseInline(d.getCommonName())).collect(Collectors.toList());
            for (Description childDescription : childDescriptions) {
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    this.callSetter(childDescription, builder, this.parseMatcher((Node)iter.next()));
                    iter.remove();
                }
            }
            if (!children.isEmpty()) {
                children.forEach(n -> DefaultLog.getInstance().warn(String.format("unrecognised child node '%s' in node '%s'%n", n.getNodeName(), licenseNode.getNodeName())));
            }
            return builder.build();
        }
        catch (RuntimeException exception) {
            DefaultLog.getInstance().error(String.format("License error in: '%s'", this.nodeText(licenseNode)));
            throw exception;
        }
    }

    @Override
    public SortedSet<ILicense> readLicenses() {
        if (this.document != null) {
            this.readFamilies();
            this.readMatcherBuilders();
            if (this.licenses.isEmpty()) {
                this.nodeListConsumer(this.document.getElementsByTagName("license"), x -> this.licenses.add(this.parseLicense((Node)x)));
                this.document = null;
            }
        }
        return Collections.unmodifiableSortedSet(this.licenses);
    }

    @Override
    public SortedSet<ILicenseFamily> readFamilies() {
        if (this.licenseFamilies.isEmpty()) {
            this.nodeListConsumer(this.document.getElementsByTagName("families"), x -> this.nodeListConsumer(x.getChildNodes(), this::parseFamily));
            this.nodeListConsumer(this.document.getElementsByTagName("approved"), x -> this.nodeListConsumer(x.getChildNodes(), this::parseApproved));
        }
        return Collections.unmodifiableSortedSet(this.licenseFamilies);
    }

    private ILicenseFamily parseFamily(Map<String, String> attributes) {
        if (attributes.containsKey("id")) {
            ILicenseFamily.Builder builder = ILicenseFamily.builder();
            builder.setLicenseFamilyCategory(attributes.get("id"));
            builder.setLicenseFamilyName((String)StringUtils.defaultIfBlank((CharSequence)attributes.get("name"), (CharSequence)attributes.get("id")));
            return builder.build();
        }
        return null;
    }

    private void parseFamily(Node familyNode) {
        if ("family".equals(familyNode.getNodeName())) {
            try {
                ILicenseFamily result = this.parseFamily(this.attributes(familyNode));
                if (result == null) {
                    throw new ConfigurationException(String.format("families/family tag requires %s attribute", "id"));
                }
                this.licenseFamilies.add(result);
            }
            catch (RuntimeException exception) {
                DefaultLog.getInstance().error(String.format("Family error in: '%s'", this.nodeText(familyNode)));
                throw exception;
            }
        }
    }

    private void parseApproved(Node approvedNode) {
        block7: {
            if ("family".equals(approvedNode.getNodeName())) {
                try {
                    Map<String, String> attributes = this.attributes(approvedNode);
                    if (attributes.containsKey("license_ref")) {
                        this.approvedFamilies.add(attributes.get("license_ref"));
                        break block7;
                    }
                    if (attributes.containsKey("id")) {
                        ILicenseFamily target = this.parseFamily(attributes);
                        if (target != null) {
                            this.licenseFamilies.add(target);
                            String familyCategory = target.getFamilyCategory();
                            if (StringUtils.isNotBlank((CharSequence)familyCategory)) {
                                this.approvedFamilies.add(familyCategory);
                            }
                        }
                        break block7;
                    }
                    throw new ConfigurationException(String.format("family tag requires %s or %s attribute", "license_ref", "id"));
                }
                catch (RuntimeException exception) {
                    DefaultLog.getInstance().error(String.format("Approved error in: '%s'", this.nodeText(approvedNode)));
                    throw exception;
                }
            }
        }
    }

    @Override
    public SortedSet<String> approvedLicenseId() {
        if (this.licenses.isEmpty()) {
            this.readLicenses();
        }
        if (this.approvedFamilies.isEmpty()) {
            TreeSet<String> result = new TreeSet<String>();
            this.licenses.stream().map(x -> x.getLicenseFamily().getFamilyCategory()).forEach(result::add);
            return result;
        }
        return Collections.unmodifiableSortedSet(this.approvedFamilies);
    }

    private void parseMatcherBuilder(Node classNode) {
        try {
            Map<String, String> attributes = this.attributes(classNode);
            if (attributes.get("class") == null) {
                throw new ConfigurationException("matcher must have a class attribute");
            }
            MatcherBuilderTracker.addBuilder(attributes.get("class"), attributes.get("name"));
        }
        catch (RuntimeException exception) {
            DefaultLog.getInstance().error(String.format("Matcher error in: '%s'", this.nodeText(classNode)));
            throw exception;
        }
    }

    @Override
    public void readMatcherBuilders() {
        this.nodeListConsumer(this.document.getElementsByTagName("matcher"), this::parseMatcherBuilder);
    }

    @Override
    public void addMatchers(URI uri) {
        this.read(uri);
    }

    static class IDRecordingBuilder
    extends AbstractBuilder {
        private final AbstractBuilder delegate;
        private final Map<String, IHeaderMatcher> matchers;

        IDRecordingBuilder(Map<String, IHeaderMatcher> matchers, AbstractBuilder delegate) {
            this.delegate = delegate;
            this.matchers = matchers;
            this.setId(delegate.getId());
        }

        @Override
        public IHeaderMatcher build() {
            IHeaderMatcher result = this.delegate.build();
            this.matchers.put(result.getId(), result);
            return result;
        }

        @Override
        public Description getDescription() {
            return this.delegate.getDescription();
        }
    }
}

