/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.configuration.builders.TextBuilder;

public abstract class ChildContainerBuilder
extends AbstractBuilder {
    protected final List<IHeaderMatcher.Builder> children = new ArrayList<IHeaderMatcher.Builder>();
    protected String resource;

    protected ChildContainerBuilder() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public AbstractBuilder setResource(String resourceName) {
        URL url = this.getClass().getResource(resourceName);
        if (url == null) {
            throw new ConfigurationException("Unable to read matching text file: " + resourceName);
        }
        try (InputStream in = url.openStream();){
            ChildContainerBuilder childContainerBuilder;
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String txt;
                while (null != (txt = buffer.readLine())) {
                    if (!StringUtils.isNotBlank((CharSequence)(txt = txt.trim()))) continue;
                    this.children.add(new TextBuilder().setSimpleText(txt));
                }
                this.resource = resourceName;
                childContainerBuilder = this;
            }
            return childContainerBuilder;
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to read matching text file: " + resourceName, e);
        }
    }

    public AbstractBuilder addEnclosed(IHeaderMatcher.Builder child) {
        this.children.add(child);
        return this;
    }

    public AbstractBuilder addEnclosed(Collection<IHeaderMatcher.Builder> children) {
        this.children.addAll(children);
        return this;
    }

    public List<IHeaderMatcher.Builder> getEnclosedBuilders() {
        return Collections.unmodifiableList(this.children);
    }

    public List<IHeaderMatcher> getEnclosed() {
        return this.children.stream().map(IHeaderMatcher.Builder::build).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(":");
        this.children.stream().map(Object::toString).forEach(x -> sb.append(System.lineSeparator()).append((String)x));
        return sb.toString();
    }
}

