/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.matchers.SPDXMatcherFactory;
import org.apache.rat.config.parameters.MatcherBuilder;
import org.apache.rat.configuration.builders.AbstractBuilder;

@MatcherBuilder(value=SPDXMatcherFactory.Match.class)
public class SpdxBuilder
extends AbstractBuilder {
    private String name;

    public SpdxBuilder setName(String name) {
        Objects.requireNonNull(name, "SPDX name must not be null");
        this.name = name;
        super.setId("SPDX:" + name);
        return this;
    }

    @Override
    public AbstractBuilder setId(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            throw new ConfigurationException("'id' is not supported for SPDX matchers. SPXD matchers always have 'SPDX:<name>' as their id");
        }
        return this;
    }

    @Override
    public SPDXMatcherFactory.Match build() {
        return SPDXMatcherFactory.INSTANCE.create(this.name);
    }

    @Override
    public String toString() {
        return "SpdxBuilder: " + this.name;
    }
}

