/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.ImplementationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;

@ConfigComponent(type=ComponentType.LICENSE)
public class SimpleLicense
implements ILicense {
    @ConfigComponent(type=ComponentType.BUILD_PARAMETER, desc="The defined license families.", name="licenseFamilies")
    private final ILicenseFamily family;
    @ConfigComponent(type=ComponentType.PARAMETER, desc="The matcher for this license.", required=true)
    private final IHeaderMatcher matcher;
    @ConfigComponent(type=ComponentType.PARAMETER, desc="The notes about this license.")
    private final String note;
    @ConfigComponent(type=ComponentType.PARAMETER, desc="The name of this license.")
    private final String name;
    @ConfigComponent(type=ComponentType.PARAMETER, desc="The ID for this license.")
    private final String id;

    SimpleLicense(ILicenseFamily family, IHeaderMatcher matcher, String notes, String name, String id) {
        Objects.requireNonNull(matcher, "Matcher must not be null");
        Objects.requireNonNull(family, "Family must not be null");
        this.family = family;
        this.matcher = matcher;
        this.note = notes;
        this.name = (String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)family.getFamilyName());
        this.id = (String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)family.getFamilyCategory().trim());
    }

    public String toString() {
        return String.format("%s:%s", this.getId(), this.getName());
    }

    @ConfigComponent(type=ComponentType.PARAMETER, desc="The license family category for this license.", required=true)
    public String getFamily() {
        return this.family.getFamilyCategory();
    }

    @Override
    public IHeaderMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void reset() {
        this.matcher.reset();
    }

    @Override
    public boolean matches(IHeaders line) {
        return this.matcher.matches(line);
    }

    @Override
    public ILicenseFamily getLicenseFamily() {
        return this.family;
    }

    public boolean equals(Object o) {
        return ILicense.equals(this, o);
    }

    public int hashCode() {
        return ILicense.hash(this);
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    implements ILicense.Builder {
        private SortedSet<ILicenseFamily> licenseFamilies;
        private IHeaderMatcher.Builder matcher;
        private final List<String> notes = new ArrayList<String>();
        private String name;
        private String id;
        private String familyCategory;

        @Override
        public Builder setMatcher(IHeaderMatcher.Builder matcher) {
            this.matcher = matcher;
            return this;
        }

        @Override
        public Builder setMatcher(IHeaderMatcher matcher) {
            this.matcher = () -> matcher;
            return this;
        }

        @Override
        public Builder setNote(String note) {
            if (StringUtils.isNotBlank((CharSequence)note)) {
                this.notes.add(note);
            }
            return this;
        }

        @Override
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder setFamily(String licenseFamilyCategory) {
            this.familyCategory = licenseFamilyCategory;
            return this;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder setLicenseFamilies(SortedSet<ILicenseFamily> licenseFamilies) {
            this.licenseFamilies = licenseFamilies;
            return this;
        }

        @Override
        public SimpleLicense build() {
            if (this.matcher == null) {
                throw new ConfigurationException("'matcher' must not be null");
            }
            if (this.licenseFamilies == null) {
                throw new ImplementationException("'licenseFamilies' must not be null");
            }
            if (StringUtils.isBlank((CharSequence)this.familyCategory)) {
                throw new ImplementationException("License 'family' must be specified");
            }
            String familyCat = ILicenseFamily.makeCategory(this.familyCategory);
            Optional<ILicenseFamily> family = this.licenseFamilies.stream().filter(f -> f.getFamilyCategory().equals(familyCat)).findFirst();
            if (!family.isPresent()) {
                throw new ConfigurationException(String.format("License family '%s' not found.", this.familyCategory));
            }
            return new SimpleLicense(family.get(), this.matcher.build(), String.join((CharSequence)System.lineSeparator(), this.notes), this.name, this.id);
        }
    }
}

