/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.xml;

import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.rat.VersionInfo;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.license.ILicense;
import org.apache.rat.report.xml.writer.IXmlWriter;
import org.apache.rat.utils.CasedString;

public class XmlElements {
    private final IXmlWriter writer;

    private static String normalizeName(String name) {
        CasedString casedName = new CasedString(CasedString.StringCase.SNAKE, name.toLowerCase(Locale.ROOT));
        return casedName.toCase(CasedString.StringCase.CAMEL);
    }

    public XmlElements(IXmlWriter xmlWriter) {
        this.writer = xmlWriter;
    }

    public XmlElements ratReport() throws RatException {
        return this.write(Elements.RAT_REPORT).write(Attributes.TIMESTAMP, DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(Calendar.getInstance())).version();
    }

    public XmlElements version() throws RatException {
        VersionInfo versionInfo = new VersionInfo();
        return this.write(Elements.VERSION).write(Attributes.PRODUCT, versionInfo.getTitle()).write(Attributes.VENDOR, versionInfo.getVendor()).write(Attributes.VERSION, versionInfo.getVersion()).closeElement();
    }

    public XmlElements license(ILicense license, boolean approved) throws RatException {
        this.write(Elements.LICENSE).write(Attributes.ID, license.getId()).write(Attributes.NAME, license.getName()).write(Attributes.APPROVAL, Boolean.valueOf(approved).toString()).write(Attributes.FAMILY, license.getLicenseFamily().getFamilyCategory());
        if (StringUtils.isNotBlank((CharSequence)license.getNote())) {
            try {
                this.write(Elements.NOTES).cdata(license.getNote()).closeElement();
            }
            catch (IOException e) {
                throw new RatException("Can not write CDATA for 'notes' element", e);
            }
        }
        return this.closeElement();
    }

    private XmlElements cdata(String data) throws IOException {
        this.writer.cdata(data);
        return this;
    }

    public XmlElements document(Document document) throws RatException {
        MetaData metaData = document.getMetaData();
        XmlElements result = this.write(Elements.RESOURCE).write(Attributes.NAME, document.getName().localized("/")).write(Attributes.TYPE, metaData.getDocumentType().toString()).write(Attributes.MEDIA_TYPE, metaData.getMediaType().toString());
        if (Document.Type.STANDARD == metaData.getDocumentType() || metaData.hasCharset()) {
            result = result.write(Attributes.ENCODING, metaData.getCharset().displayName());
        }
        if (document.isIgnored()) {
            result = result.write(Attributes.IS_DIRECTORY, Boolean.toString(document.isDirectory()));
        }
        return result;
    }

    public XmlElements statistics() throws RatException {
        return this.write(Elements.STATISTICS);
    }

    public XmlElements statistic(String name, int count, String description, boolean isOk) throws RatException {
        return this.write(Elements.STATISTIC).write(Attributes.NAME, name).write(Attributes.COUNT, Integer.toString(count)).write(Attributes.APPROVAL, Boolean.toString(isOk)).write(Attributes.DESCRIPTION, description).closeElement();
    }

    public XmlElements licenseCategory(String name, int count) throws RatException {
        return this.write(Elements.LICENSE_CATEGORY).write(Attributes.NAME, name).write(Attributes.COUNT, Integer.toString(count)).closeElement();
    }

    public XmlElements licenseName(String name, int count) throws RatException {
        return this.write(Elements.LICENSE_NAME).write(Attributes.NAME, name).write(Attributes.COUNT, Integer.toString(count)).closeElement();
    }

    public XmlElements documentType(String name, int count) throws RatException {
        return this.write(Elements.DOCUMENT_TYPE).write(Attributes.NAME, name).write(Attributes.COUNT, Integer.toString(count)).closeElement();
    }

    public XmlElements closeElement() throws RatException {
        try {
            this.writer.closeElement();
            return this;
        }
        catch (IOException e) {
            throw new RatException("Cannot close currently open element", e);
        }
    }

    private XmlElements write(Elements element) throws RatException {
        try {
            this.writer.openElement(element.getElementName());
            return this;
        }
        catch (IOException e) {
            throw new RatException("Cannot open start element: " + element.elementName, e);
        }
    }

    public XmlElements write(Attributes attribute, String value) throws RatException {
        try {
            this.writer.attribute(XmlElements.normalizeName(attribute.name()), value);
            return this;
        }
        catch (IOException e) {
            throw new RatException("Cannot open add attribute: " + (Object)((Object)attribute), e);
        }
    }

    public static enum Elements {
        RAT_REPORT("rat-report"),
        VERSION,
        RESOURCE,
        LICENSE,
        NOTES,
        STATISTICS,
        STATISTIC,
        LICENSE_NAME,
        LICENSE_CATEGORY,
        DOCUMENT_TYPE;

        private final String elementName;

        private Elements(String elementName) {
            this.elementName = elementName;
        }

        private Elements() {
            this.elementName = XmlElements.normalizeName(this.name());
        }

        public String getElementName() {
            return this.elementName;
        }
    }

    public static enum Attributes {
        TIMESTAMP,
        VERSION,
        PRODUCT,
        VENDOR,
        APPROVAL,
        FAMILY,
        TYPE,
        ID,
        NAME,
        COUNT,
        DESCRIPTION,
        MEDIA_TYPE,
        ENCODING,
        IS_DIRECTORY;

    }
}

