/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.walker;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.rat.api.RatException;
import org.apache.rat.commandline.Arg;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.document.FileDocument;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.walker.DirectoryWalker;

public class FileListWalker
implements IReportable {
    private final FileDocument source;
    private final DocumentName rootDoc;
    private final DocumentName baseDoc;

    public FileListWalker(FileDocument source) {
        this.source = source;
        File baseDir = source.getFile().getParentFile().getAbsoluteFile();
        this.baseDoc = DocumentName.builder(baseDir).build();
        File p = baseDir;
        while (p.getParentFile() != null) {
            p = p.getParentFile();
        }
        this.rootDoc = DocumentName.builder(p).build();
    }

    private FileDocument createDocument(String unixFileName) {
        DocumentName sourceName = this.source.getName();
        String finalName = ExclusionUtils.convertSeparator(unixFileName, "/", sourceName.getDirectorySeparator());
        DocumentName documentBase = unixFileName.startsWith("/") ? this.rootDoc : this.baseDoc;
        DocumentName documentName = documentBase.resolve(finalName);
        File documentFile = documentName.asFile();
        return new FileDocument(documentBase, documentFile, DocumentNameMatcher.MATCHES_ALL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(RatReport report) throws RatException {
        DefaultLog.getInstance().debug(String.format("Reading file name: %s due to option %s", this.source, Arg.SOURCE.option()));
        DocumentName sourceName = this.getName();
        try (Reader reader = this.source.reader();){
            for (String docName : IOUtils.readLines((Reader)reader)) {
                try {
                    DefaultLog.getInstance().debug("Reading file name: " + docName);
                    FileDocument document = this.createDocument(docName);
                    if (document.isDirectory()) {
                        new DirectoryWalker(document).run(report);
                        continue;
                    }
                    report.report(document);
                }
                catch (RatException e) {
                    throw new RatException(String.format("Error reading file `%s` read from `%s`", docName, sourceName), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new RatException("can not read " + sourceName.getName(), e);
        }
    }

    @Override
    public DocumentName getName() {
        return this.source.getName();
    }
}

