/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.rat.config.SourceCodeManagementSystems;
import org.codehaus.plexus.util.AbstractScanner;

public final class ExclusionHelper {
    static final List<String> MAVEN_DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList("target/**/*", "cobertura.ser", "**/MANIFEST.MF", "release.properties", ".repository", "build.log", ".mvn/**/*", "pom.xml.releaseBackup"));
    static final List<String> ECLIPSE_DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList(".checkstyle", ".classpath", ".factorypath", ".project", ".settings/**/*"));
    static final List<String> IDEA_DEFAULT_EXCLUDES = Collections.unmodifiableList(Arrays.asList("*.iml", "*.ipr", "*.iws", ".idea/**/*"));

    public static Set<String> addPlexusAndScmDefaults(Log log, boolean useDefaultExcludes) {
        HashSet<String> excludeList = new HashSet<String>();
        if (useDefaultExcludes) {
            log.debug((CharSequence)"Adding plexus default exclusions...");
            Collections.addAll(excludeList, AbstractScanner.DEFAULTEXCLUDES);
            log.debug((CharSequence)"Adding SCM default exclusions...");
            excludeList.addAll(SourceCodeManagementSystems.getPluginExclusions());
        } else {
            log.debug((CharSequence)"rat.useDefaultExcludes set to false. Plexus and SCM default exclusions will not be added");
        }
        return excludeList;
    }

    public static Set<String> addMavenDefaults(Log log, boolean useMavenDefaultExcludes) {
        HashSet<String> excludeList = new HashSet<String>();
        if (useMavenDefaultExcludes) {
            log.debug((CharSequence)"Adding exclusions often needed by Maven projects...");
            excludeList.addAll(MAVEN_DEFAULT_EXCLUDES);
        } else {
            log.debug((CharSequence)"rat.useMavenDefaultExcludes set to false. Exclusions often needed by Maven projects will not be added.");
        }
        return excludeList;
    }

    public static Set<String> addEclipseDefaults(Log log, boolean useEclipseDefaultExcludes) {
        HashSet<String> excludeList = new HashSet<String>();
        if (useEclipseDefaultExcludes) {
            log.debug((CharSequence)"Adding exclusions often needed by projects developed in Eclipse...");
            excludeList.addAll(ECLIPSE_DEFAULT_EXCLUDES);
        } else {
            log.debug((CharSequence)"rat.useEclipseDefaultExcludes set to false. Exclusions often needed by projects developed in Eclipse will not be added.");
        }
        return excludeList;
    }

    public static Set<String> addIdeaDefaults(Log log, boolean useIdeaDefaultExcludes) {
        HashSet<String> excludeList = new HashSet<String>();
        if (useIdeaDefaultExcludes) {
            log.debug((CharSequence)"Adding exclusions often needed by projects developed in IDEA...");
            excludeList.addAll(IDEA_DEFAULT_EXCLUDES);
        } else {
            log.debug((CharSequence)"rat.useIdeaDefaultExcludes set to false. Exclusions often needed by projects developed in IDEA will not be added.");
        }
        return excludeList;
    }
}

