/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.rave.rest.PageUsersResource;
import org.apache.rave.rest.RegionsResource;
import org.apache.rave.rest.model.Page;
import org.apache.rave.rest.model.SearchResult;

@Path(value="/pages")
public interface PagesResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public SearchResult<Page> getPages();

    @GET
    @Path(value="/{context}/{identifier}")
    @Produces(value={"application/json"})
    public SearchResult<Page> getContextPages(@PathParam(value="context") String var1, @PathParam(value="identifier") String var2);

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Page createPage(@DefaultValue(value="") @QueryParam(value="templateId") String var1, Page var2);

    @DELETE
    @Path(value="/{pageId}")
    public Page deletePage(@PathParam(value="pageId") String var1);

    @GET
    @Path(value="/{pageId}")
    @Produces(value={"application/json"})
    public Page getPage(@PathParam(value="pageId") String var1);

    @PUT
    @Path(value="/{pageId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Page updatePage(@PathParam(value="pageId") String var1, Page var2);

    @GET
    @Path(value="/{pageId}")
    @Produces(value={"application/vnd.omdl+xml"})
    public Response getPageOmdl(@PathParam(value="pageId") String var1);

    @Path(value="/{pageId}/regions")
    public RegionsResource getRegionsResource(@PathParam(value="pageId") String var1);

    @Path(value="/{pageId}/members")
    public PageUsersResource getPageMembersResource(@PathParam(value="pageId") String var1);
}

