/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.rave.portal.web.util;

/**
 * Utility class for {@link org.apache.rave.model.PortalPreference} keys
 */
public final class PortalPreferenceKeys {
    private PortalPreferenceKeys() { }

    public static final String TITLE_SUFFIX = "titleSuffix";
    public static final String PAGE_SIZE = "pageSize";
    public static final String JAVASCRIPT_DEBUG_MODE = "javaScriptDebugMode";
    public static final String INITIAL_WIDGET_STATUS = "initialWidgetStatus";
    public static final String EXTERNAL_MARKETPLACE_URL = "externalMarketplaceUrl";
    public static final String WIDGET_HEIGHT = "defaultWidgetHeight";
    public static final String SHOW_STACK_TRACE = "showStackTrace";
}
