/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.util.omdl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.apache.rave.model.Page;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.model.util.omdl.OmdlConstants;
import org.apache.rave.portal.model.util.omdl.OmdlModelUtils;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetService;

@XmlRootElement(name="workspace")
@XmlAccessorType(value=XmlAccessType.NONE)
public class OmdlOutputAdapter
implements OmdlConstants {
    private Page page;
    private String wookieUrl;
    @XmlElement
    private Status status;
    @XmlElement
    private String identifier;
    @XmlElement
    private String title;
    @XmlElement
    private String description;
    @XmlElement
    private String creator;
    @XmlElement
    private String date;
    @XmlElement
    private String layout;
    private List<OmdlWidget> widgetsList;
    private WidgetService widgetService;
    private UserService userService;

    public OmdlOutputAdapter() {
    }

    public OmdlOutputAdapter(WidgetService widgetService, UserService userService) {
        this.widgetService = widgetService;
        this.userService = userService;
    }

    public void buildModel(Page page, String omdlUrl, String wookieUrl) {
        this.wookieUrl = wookieUrl;
        OmdlWidget omdlWidget = null;
        this.status = new Status(OmdlModelUtils.getDate(), "");
        this.page = page;
        this.identifier = omdlUrl;
        this.title = page.getName();
        this.description = "";
        this.creator = this.getCreator(page);
        this.date = OmdlModelUtils.getDate();
        this.layout = OmdlModelUtils.getOmdlLayoutForExport(page.getPageLayout().getCode());
        this.widgetsList = new ArrayList<OmdlWidget>();
        for (int i = 0; i < page.getRegions().size(); ++i) {
            for (int j = 0; j < ((Region)page.getRegions().get(i)).getRegionWidgets().size(); ++j) {
                Widget widget = this.widgetService.getWidget(((RegionWidget)((Region)page.getRegions().get(i)).getRegionWidgets().get(j)).getWidgetId());
                omdlWidget = new OmdlWidget();
                omdlWidget.setUrl(widget.getUrl());
                omdlWidget.setLink(this.createLinkElement(widget.getType(), widget.getUrl()));
                String position = OmdlModelUtils.getPositionString(i + 1, page.getRegions().size(), j + 1, ((Region)page.getRegions().get(i)).getRegionWidgets().size());
                if (position != null && position != "") {
                    omdlWidget.setPosition(position);
                }
                omdlWidget.setWidgetType("unknown");
                this.widgetsList.add(omdlWidget);
            }
        }
    }

    public void setWookieUrl(String wookieUrl) {
        this.wookieUrl = wookieUrl;
    }

    private Link createLinkElement(String appType, String url) {
        Link link = new Link();
        if (appType.equals("OpenSocial")) {
            appType = "application/vnd-opensocial+xml";
        } else if (appType.equals("W3C")) {
            appType = "application/widget";
            url = this.wookieUrl + "/widgets/" + url;
        } else {
            appType = "application/unknown";
        }
        link.setType(appType);
        link.setRel("source");
        link.setHref(url);
        return link;
    }

    private String getCreator(Page page) {
        String result = "";
        User user = this.userService.getUserById(page.getOwnerId());
        result = user.getDisplayName();
        if ((result == null || result.equals("")) && ((result = user.getPreferredName()) == null || result.equals(""))) {
            result = user.getUsername();
        }
        return result;
    }

    @XmlElement(name="app")
    public List<OmdlWidget> getWidgetsList() {
        return this.widgetsList;
    }

    public void setWidgetsList(List<OmdlWidget> widgetsList) {
        this.widgetsList = widgetsList;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    private static class OmdlWidget {
        @XmlAttribute(name="id")
        private String url;
        @XmlElement(name="type")
        private String widgetType;
        @XmlElement
        private Link link;
        @XmlElement
        private String position;

        public void setPosition(String position) {
            this.position = position;
        }

        public void setWidgetType(String widgetType) {
            this.widgetType = widgetType;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setLink(Link link) {
            this.link = link;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    private static class Link {
        @XmlAttribute
        private String rel;
        @XmlAttribute
        private String type;
        @XmlAttribute
        private String href;

        public void setHref(String href) {
            this.href = href;
        }

        public void setRel(String rel) {
            this.rel = rel;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    private static class Status {
        @XmlAttribute
        private String date;
        @XmlValue
        private String text;

        public Status() {
        }

        public Status(String date, String text) {
            this.date = date;
            this.text = text;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }
    }
}

