/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.Region;
import org.apache.rave.model.User;
import org.apache.rave.portal.repository.RegionRepository;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultRegionPermissionEvaluator
extends AbstractModelPermissionEvaluator<Region> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private RegionRepository regionRepository;
    private UserRepository userRepository;

    @Autowired
    public DefaultRegionPermissionEvaluator(RegionRepository regionRepository, UserRepository userRepository) {
        this.regionRepository = regionRepository;
        this.userRepository = userRepository;
    }

    @Override
    public Class<Region> getType() {
        return Region.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, Region region, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, region, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (Region)this.regionRepository.get((String)((Object)targetId)), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, Region region, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<Region> trustedRegionContainer = new ArrayList<Region>();
        if (super.hasPermission(authentication, region, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case CREATE: 
            case DELETE: 
            case UPDATE: {
                hasPermission = this.isRegionOwner(authentication, region, trustedRegionContainer, trustedDomainObject) || this.isRegionMember(authentication, region, trustedRegionContainer, trustedDomainObject, true);
                break;
            }
            case READ: {
                hasPermission = this.isRegionOwner(authentication, region, trustedRegionContainer, trustedDomainObject) || this.isRegionMember(authentication, region, trustedRegionContainer, trustedDomainObject, false);
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private Region getTrustedRegion(String regionId, List<Region> trustedRegionContainer) {
        Region region = null;
        if (trustedRegionContainer.isEmpty()) {
            region = (Region)this.regionRepository.get(regionId);
            trustedRegionContainer.add(region);
        } else {
            region = trustedRegionContainer.get(0);
        }
        return region;
    }

    private boolean isRegionOwner(Authentication authentication, Region region, List<Region> trustedRegionContainer, boolean trustedDomainObject) {
        Region trustedRegion = null;
        trustedRegion = trustedDomainObject ? region : this.getTrustedRegion(region.getId(), trustedRegionContainer);
        return this.isRegionOwnerByUserId(authentication, trustedRegion.getPage().getOwnerId());
    }

    private boolean isRegionOwnerByUserId(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }

    private boolean isRegionOwnerById(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isRegionOwnerById(authentication, (String)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }

    private boolean isRegionMember(Authentication authentication, Region region, List<Region> trustedRegionContainer, boolean trustedDomainObject, boolean checkEditorStatus) {
        Region trustedRegion = null;
        trustedRegion = trustedDomainObject ? region : this.getTrustedRegion(region.getId(), trustedRegionContainer);
        Page containerPage = trustedRegion.getPage();
        if (containerPage.getMembers() == null) {
            return false;
        }
        String viewer = ((User)authentication.getPrincipal()).getUsername();
        do {
            for (PageUser pageUser : containerPage.getMembers()) {
                User user = (User)this.userRepository.get(pageUser.getUserId());
                if (user == null || !user.getUsername().equals(viewer)) continue;
                this.log.info("User " + viewer + " is a member of page " + containerPage.getId());
                if (checkEditorStatus) {
                    return pageUser.isEditor();
                }
                return true;
            }
        } while ((containerPage = containerPage.getParentPage()) != null);
        return false;
    }
}

