/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.User;
import org.apache.rave.portal.repository.RegionWidgetRepository;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultRegionWidgetPermissionEvaluator
extends AbstractModelPermissionEvaluator<RegionWidget> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private RegionWidgetRepository regionWidgetRepository;
    private UserRepository userRepository;

    @Autowired
    public DefaultRegionWidgetPermissionEvaluator(RegionWidgetRepository regionWidgetRepository, UserRepository userRepository) {
        this.regionWidgetRepository = regionWidgetRepository;
        this.userRepository = userRepository;
    }

    @Override
    public Class<RegionWidget> getType() {
        return RegionWidget.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, RegionWidget regionWidget, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, regionWidget, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (RegionWidget)this.regionWidgetRepository.get((String)((Object)targetId)), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, RegionWidget regionWidget, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<RegionWidget> trustedRegionWidgetContainer = new ArrayList<RegionWidget>();
        if (super.hasPermission(authentication, regionWidget, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case CREATE: 
            case DELETE: 
            case UPDATE: {
                hasPermission = this.isRegionWidgetOwner(authentication, regionWidget, trustedRegionWidgetContainer, trustedDomainObject) || this.isRegionWidgetMember(authentication, regionWidget, trustedRegionWidgetContainer, trustedDomainObject, true);
                break;
            }
            case READ: {
                hasPermission = this.isRegionWidgetOwner(authentication, regionWidget, trustedRegionWidgetContainer, trustedDomainObject) || this.isRegionWidgetMember(authentication, regionWidget, trustedRegionWidgetContainer, trustedDomainObject, false);
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private RegionWidget getTrustedRegionWidget(String regionWidgetId, List<RegionWidget> trustedRegionWidgetContainer) {
        RegionWidget regionWidget = null;
        if (trustedRegionWidgetContainer.isEmpty()) {
            regionWidget = (RegionWidget)this.regionWidgetRepository.get(regionWidgetId);
            trustedRegionWidgetContainer.add(regionWidget);
        } else {
            regionWidget = trustedRegionWidgetContainer.get(0);
        }
        return regionWidget;
    }

    private boolean isRegionWidgetOwner(Authentication authentication, RegionWidget regionWidget, List<RegionWidget> trustedRegionWidgetContainer, boolean trustedDomainObject) {
        RegionWidget trustedRegionWidget = null;
        trustedRegionWidget = trustedDomainObject ? regionWidget : this.getTrustedRegionWidget(regionWidget.getId(), trustedRegionWidgetContainer);
        return this.isRegionWidgetOwnerByUsername(authentication, this.getUserIdFromRegionWidget(trustedRegionWidget));
    }

    private boolean isRegionWidgetOwnerByUsername(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }

    private boolean isRegionWidgetOwnerById(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isRegionWidgetOwnerById(authentication, (String)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }

    private String getUserIdFromRegionWidget(RegionWidget regionWidget) {
        return regionWidget.getRegion().getPage().getOwnerId();
    }

    private boolean isRegionWidgetMember(Authentication authentication, RegionWidget regionWidget, List<RegionWidget> trustedRegionWidgetContainer, boolean trustedDomainObject, boolean checkEditorStatus) {
        RegionWidget trustedRegionWidget = null;
        trustedRegionWidget = trustedDomainObject ? regionWidget : this.getTrustedRegionWidget(regionWidget.getId(), trustedRegionWidgetContainer);
        Page containerPage = trustedRegionWidget.getRegion().getPage();
        if (containerPage.getMembers() == null) {
            return false;
        }
        String viewer = ((User)authentication.getPrincipal()).getUsername();
        do {
            for (PageUser pageUser : containerPage.getMembers()) {
                User user = (User)this.userRepository.get(pageUser.getUserId());
                if (user == null || !user.getUsername().equals(viewer)) continue;
                this.log.info("User " + viewer + " is a member of page " + containerPage.getId());
                if (checkEditorStatus) {
                    return pageUser.isEditor();
                }
                return true;
            }
        } while ((containerPage = containerPage.getParentPage()) != null);
        return false;
    }
}

