/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.model.User;
import org.apache.rave.model.WidgetRating;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultWidgetRatingPermissionEvaluator
extends AbstractModelPermissionEvaluator<WidgetRating> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WidgetRepository widgetRepository;

    @Autowired
    public DefaultWidgetRatingPermissionEvaluator(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Override
    public Class<WidgetRating> getType() {
        return WidgetRating.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, WidgetRating widgetRating, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, widgetRating, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, this.widgetRepository.getRatingById(null, (String)((Object)targetId)), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, WidgetRating widgetRating, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<WidgetRating> trustedWidgetRatingContainer = new ArrayList<WidgetRating>();
        if (super.hasPermission(authentication, widgetRating, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case CREATE: {
                hasPermission = this.isWidgetRatingOwnerById(authentication, widgetRating.getUserId());
                break;
            }
            case DELETE: 
            case READ: 
            case UPDATE: {
                hasPermission = this.isWidgetRatingOwner(authentication, widgetRating, trustedWidgetRatingContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private WidgetRating getTrustedWidgetRating(String widgetRatingId, List<WidgetRating> trustedWidgetRatingContainer) {
        WidgetRating widgetRating = null;
        if (trustedWidgetRatingContainer.isEmpty()) {
            widgetRating = this.widgetRepository.getRatingById(null, widgetRatingId);
            trustedWidgetRatingContainer.add(widgetRating);
        } else {
            widgetRating = trustedWidgetRatingContainer.get(0);
        }
        return widgetRating;
    }

    private boolean isWidgetRatingOwner(Authentication authentication, WidgetRating widgetRating, List<WidgetRating> trustedWidgetRatingContainer, boolean trustedDomainObject) {
        WidgetRating trustedWidgetRating = null;
        trustedWidgetRating = trustedDomainObject ? widgetRating : this.getTrustedWidgetRating(widgetRating.getId(), trustedWidgetRatingContainer);
        return this.isWidgetRatingOwnerById(authentication, trustedWidgetRating.getUserId());
    }

    private boolean isWidgetRatingOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isWidgetRatingOwnerById(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isWidgetRatingOwnerById(authentication, (String)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }
}

