/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service;

import java.util.List;
import org.apache.rave.model.Category;
import org.apache.rave.model.User;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;

public interface CategoryService {
    @PostAuthorize(value="returnObject == null or hasPermission(returnObject, 'read')")
    public Category get(String var1);

    @PostFilter(value="hasPermission(filterObject, 'read')")
    public List<Category> getAllList();

    public SearchResult<Category> getAll();

    public SearchResult<Category> getLimitedList(int var1, int var2);

    @PostAuthorize(value="hasPermission(returnObject, 'create')")
    public Category create(String var1, User var2);

    @PreAuthorize(value="hasPermission(#categoryId, 'org.apache.rave.model.Category', 'update')")
    public Category update(String var1, String var2, User var3);

    @PreAuthorize(value="hasPermission(#category.id, 'org.apache.rave.model.Category', 'delete')")
    public void delete(Category var1);
}

