/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service;

import java.util.List;
import java.util.Map;
import org.apache.rave.model.Page;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;

public interface PageService {
    public SearchResult<Page> getAll();

    public SearchResult<Page> getLimited(int var1, int var2);

    @PostAuthorize(value="returnObject == null or hasPermission(returnObject, 'read')")
    public Page getPage(String var1);

    @Deprecated
    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.model.User'), 'org.apache.rave.model.Page', 'read')")
    public List<Page> getAllUserPages(String var1);

    @Deprecated
    @PostAuthorize(value="returnObject == null or hasPermission(returnObject, 'read')")
    public Page getPersonProfilePage(String var1);

    @PostFilter(value="hasPermission(filterObject, 'read')")
    public List<Page> getPages(String var1, String var2);

    public Page getPageFromList(String var1, List<Page> var2);

    public Page getDefaultPageFromList(List<Page> var1);

    @PostAuthorize(value="hasPermission(returnObject, 'create')")
    public Page addNewPage(String var1, String var2, String var3);

    @PostAuthorize(value="hasPermission(returnObject, 'create')")
    public Page addNewUserPage(String var1, String var2);

    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.model.User'), 'org.apache.rave.model.Page', 'create')")
    public Page addNewDefaultUserPage(String var1);

    @PostAuthorize(value="hasPermission(returnObject, 'create')")
    public Page addNewSubPage(String var1, String var2, Page var3);

    public String getDefaultPageName();

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'delete')")
    public void deletePage(String var1);

    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.model.User'), 'org.apache.rave.model.Page', 'delete')")
    public int deletePages(String var1, String var2);

    @PreAuthorize(value="hasPermission(#regionWidgetId, 'org.apache.rave.model.RegionWidget', 'update') and hasPermission(#toRegionId, 'org.apache.rave.model.Region', 'update') and hasPermission(#fromRegionId, 'org.apache.rave.model.Region', 'update')")
    public RegionWidget moveRegionWidget(String var1, int var2, String var3, String var4);

    @PreAuthorize(value="hasPermission(#regionWidgetId, 'org.apache.rave.model.RegionWidget', 'update') and hasPermission(#toPageId, 'org.apache.rave.model.Page', 'update')")
    public RegionWidget moveRegionWidgetToPage(String var1, String var2);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'update') and hasPermission(#widgetId, 'org.apache.rave.model.Widget', 'read')")
    public RegionWidget addWidgetToPage(String var1, String var2);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'update') and hasPermission(#widgetId, 'org.apache.rave.model.Widget', 'read')")
    public RegionWidget addWidgetToPageRegion(String var1, String var2, String var3);

    @PreAuthorize(value="hasPermission(#regionWidgetId, 'org.apache.rave.model.RegionWidget', 'delete')")
    public Region removeWidgetFromPage(String var1);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'update')")
    public Page updatePage(String var1, String var2, String var3);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'update')")
    public Page updatePage(String var1, String var2, String var3, Map<String, Object> var4);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'read') and hasPermission(#moveAfterPageId, 'org.apache.rave.model.Page', 'read')")
    public Page movePage(String var1, String var2);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'read')")
    public Page movePageToDefault(String var1);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'read')")
    public Page clonePageForUser(String var1, String var2, String var3);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'update')")
    public Boolean addMemberToPage(String var1, String var2);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'read')")
    public Boolean removeMemberFromPage(String var1, String var2);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'read')")
    public Boolean updateSharedPageStatus(String var1, String var2);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'read')")
    public Boolean updateSharedPageStatus(String var1, String var2, String var3);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.model.Page', 'update')")
    public Boolean updatePageEditingStatus(String var1, String var2, boolean var3);
}

