/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.Date;
import java.util.List;
import org.apache.rave.model.Category;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.impl.CategoryImpl;
import org.apache.rave.portal.repository.CategoryRepository;
import org.apache.rave.portal.service.CategoryService;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultCategoryService
implements CategoryService {
    private final CategoryRepository categoryRepository;

    @Autowired
    public DefaultCategoryService(CategoryRepository categoryRepository) {
        this.categoryRepository = categoryRepository;
    }

    @Override
    public Category get(String id) {
        return (Category)this.categoryRepository.get(id);
    }

    @Override
    public List<Category> getAllList() {
        return this.categoryRepository.getAll();
    }

    @Override
    public SearchResult<Category> getAll() {
        int count = this.categoryRepository.getCountAll();
        List categories = this.categoryRepository.getAll();
        return new SearchResult(categories, count);
    }

    @Override
    public SearchResult<Category> getLimitedList(int offset, int pageSize) {
        int count = this.categoryRepository.getCountAll();
        List categories = this.categoryRepository.getLimitedList(offset, pageSize);
        SearchResult searchResult = new SearchResult(categories, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    @Transactional
    public Category create(String text, User createdUser) {
        CategoryImpl category = new CategoryImpl();
        Date now = new Date();
        category.setText(text);
        category.setCreatedDate(now);
        category.setCreatedUserId(createdUser.getId());
        category.setLastModifiedDate(now);
        category.setLastModifiedUserId(createdUser.getId());
        return (Category)this.categoryRepository.save(category);
    }

    @Override
    @Transactional
    public Category update(String categoryId, String text, User lastModifiedUser) {
        Category category = (Category)this.categoryRepository.get(categoryId);
        category.setText(text);
        category.setLastModifiedDate(new Date());
        category.setLastModifiedUserId(lastModifiedUser.getId());
        this.categoryRepository.save(category);
        return category;
    }

    @Override
    @Transactional
    public void delete(Category category) {
        Category categoryToBeDeleted = (Category)this.categoryRepository.get(category.getId());
        this.categoryRepository.delete(categoryToBeDeleted);
    }
}

