/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import org.apache.rave.exception.EmailException;
import org.apache.rave.portal.service.EmailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactoryBean;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class DefaultEmailService
implements EmailService {
    @Autowired
    private SimpleMailMessage emailServiceMailMessage;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private FreeMarkerConfigurationFactoryBean freemarkerMailConfiguration;
    private static Logger log = LoggerFactory.getLogger(DefaultEmailService.class);

    @Override
    public void sendEmail(String to, String subject, String templateName, Map<String, Object> templateData) {
        SimpleMailMessage message = new SimpleMailMessage(this.emailServiceMailMessage);
        message.setSubject(subject);
        message.setTo(to);
        Configuration configuration = this.freemarkerMailConfiguration.getObject();
        String text = this.parseTemplate(configuration, templateData, templateName);
        message.setText(text);
        this.mailSender.send(message);
    }

    private String parseTemplate(Configuration configuration, Map<String, Object> templateData, String templateName) {
        try {
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)configuration.getTemplate(templateName), templateData);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error("Error parsing email template" + templateName, (Throwable)e);
            }
            throw new EmailException("Username reminder: error parsing email template" + templateName);
        }
        catch (TemplateException e) {
            if (log.isDebugEnabled()) {
                log.error("failed to render email template " + templateName, (Throwable)e);
            }
            throw new EmailException("Username reminder: error rendering email template: " + templateName);
        }
    }
}

