/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.rave.exception.DuplicateItemException;
import org.apache.rave.model.Page;
import org.apache.rave.model.Region;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.model.util.omdl.BadOmdlXmlFormatException;
import org.apache.rave.portal.model.util.omdl.OmdlConstants;
import org.apache.rave.portal.model.util.omdl.OmdlInputAdapter;
import org.apache.rave.portal.model.util.omdl.OmdlModelUtils;
import org.apache.rave.portal.model.util.omdl.OmdlOutputAdapter;
import org.apache.rave.portal.model.util.omdl.OmdlWidgetReference;
import org.apache.rave.portal.service.OmdlService;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.RemoteWidgetResolverService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class DefaultOmdlService
implements OmdlService,
OmdlConstants {
    private static Logger logger = LoggerFactory.getLogger(DefaultOmdlService.class);
    @Value(value="${provider.wookie.wookieServerUrl}")
    private String wookieUrl;
    private PageService pageService;
    private WidgetService widgetService;
    private UserService userService;
    private RemoteWidgetResolverService widgetResolverService;

    public DefaultOmdlService() {
    }

    @Autowired
    public DefaultOmdlService(PageService pageService, WidgetService widgetService, UserService userService, RemoteWidgetResolverService widgetResolverService) {
        this.pageService = pageService;
        this.widgetService = widgetService;
        this.userService = userService;
        this.widgetResolverService = widgetResolverService;
    }

    @Override
    public OmdlOutputAdapter exportOmdl(String pageId, String omdlUrl) {
        Page page = this.pageService.getPage(pageId);
        OmdlOutputAdapter omdl = new OmdlOutputAdapter(this.widgetService, this.userService);
        omdl.buildModel(page, omdlUrl, this.wookieUrl);
        return omdl;
    }

    @Override
    public Page importOmdl(MultipartFile multipartFile, String pageName) throws DuplicateItemException {
        Page page = null;
        OmdlInputAdapter omdlInputAdapter = new OmdlInputAdapter();
        File temp = null;
        String xml = null;
        try {
            if (multipartFile != null && multipartFile.getSize() > 0L) {
                String tempUploadFolder = System.getProperty("java.io.tmpdir");
                temp = new File(tempUploadFolder, multipartFile.getOriginalFilename());
                multipartFile.transferTo(temp);
                xml = FileUtils.readFileToString((File)temp);
            }
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        Document root = this.initializeBuilder(xml);
        if (root != null) {
            try {
                this.parseOmdlFile(root, omdlInputAdapter);
            }
            catch (BadOmdlXmlFormatException e) {
                logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        page = this.pageService.addNewUserPage(pageName, omdlInputAdapter.getLayoutCode());
        switch (page.getRegions().size()) {
            case 1: {
                this.populateRegionWidgets(page, omdlInputAdapter.getAllUrls(), ((Region)page.getRegions().get(0)).getId());
                break;
            }
            case 2: {
                this.populateRegionWidgets(page, omdlInputAdapter.getAllLeftUrls(), ((Region)page.getRegions().get(0)).getId());
                this.populateRegionWidgets(page, omdlInputAdapter.getAllRightUrls(), ((Region)page.getRegions().get(1)).getId());
                break;
            }
            case 3: {
                this.populateRegionWidgets(page, omdlInputAdapter.getAllLeftUrls(), ((Region)page.getRegions().get(0)).getId());
                this.populateRegionWidgets(page, omdlInputAdapter.getAllCenterUrls(), ((Region)page.getRegions().get(1)).getId());
                this.populateRegionWidgets(page, omdlInputAdapter.getAllRightUrls(), ((Region)page.getRegions().get(2)).getId());
                break;
            }
            case 4: {
                this.populateRegionWidgets(page, omdlInputAdapter.getAllLeftUrls(), ((Region)page.getRegions().get(0)).getId());
                this.populateRegionWidgets(page, omdlInputAdapter.getAllCenterUrls(), ((Region)page.getRegions().get(1)).getId());
                this.populateRegionWidgets(page, omdlInputAdapter.getAllRightUrls(), ((Region)page.getRegions().get(2)).getId());
                this.populateRegionWidgets(page, omdlInputAdapter.getAllUnknownUrls(), ((Region)page.getRegions().get(3)).getId());
                break;
            }
        }
        return page;
    }

    private void populateRegionWidgets(Page page, List<OmdlWidgetReference> widgetReferences, String regionId) {
        Widget raveWidget = null;
        for (OmdlWidgetReference widgetReference : widgetReferences) {
            String providerType;
            logger.info("Found OMDL widget reference (" + widgetReference.getWidgetIdentifier() + ")");
            raveWidget = this.widgetService.getWidgetByUrl(widgetReference.getWidgetIdentifier());
            if (raveWidget == null && !(providerType = widgetReference.getRaveWidgetTypeFromFormatType()).equals(null)) {
                try {
                    Widget resolvedWidget = this.widgetResolverService.resolveAndDownloadWidgetMetadata(widgetReference.getWidgetLink(), providerType);
                    if (resolvedWidget != null) {
                        if (this.widgetService.getWidgetByUrl(resolvedWidget.getUrl()) == null) {
                            raveWidget = this.widgetResolverService.addWidget(resolvedWidget);
                            logger.info("Widget added to rave. (" + raveWidget.getUrl() + ")");
                        } else {
                            logger.info("Widget was already added to rave. (" + resolvedWidget.getUrl() + ")");
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Problem installing widget: " + e.getMessage());
                    throw new RuntimeException(e);
                }
            }
            if (raveWidget != null) {
                if (this.widgetResolverService.isPublished()) {
                    this.pageService.addWidgetToPageRegion(page.getId(), raveWidget.getId(), regionId);
                    continue;
                }
                logger.error("Unable to add widget to page as the default status is set to PREVIEW. (" + raveWidget.getUrl() + ")");
                continue;
            }
            logger.error("Unable to resolve widget entry found in OMDL file. " + widgetReference.getWidgetIdentifier() + " : " + widgetReference.getWidgetLink());
        }
    }

    private void parseOmdlFile(Document xml, OmdlInputAdapter omdlInputAdapter) throws BadOmdlXmlFormatException {
        Node node;
        Node node2;
        Element rootEl = xml.getDocumentElement();
        String rootNodename = rootEl.getNodeName();
        String namespace = rootEl.getNamespaceURI();
        if (rootNodename != "workspace") {
            throw new BadOmdlXmlFormatException("Root node must be <workspace>");
        }
        if (namespace != "http://omdl.org" && namespace != "http://omdl.org/") {
            throw new BadOmdlXmlFormatException("Default xml namespace must be http://omdl.org");
        }
        String title = null;
        NodeList nodeList = rootEl.getElementsByTagNameNS(namespace, "title");
        if (nodeList.getLength() > 0 && (node2 = rootEl.getElementsByTagNameNS(namespace, "title").item(0)).getTextContent() != null) {
            title = node2.getTextContent();
        }
        omdlInputAdapter.setName(title);
        String layoutCode = null;
        nodeList = rootEl.getElementsByTagNameNS(namespace, "layout");
        if (nodeList.getLength() > 0 && (node = rootEl.getElementsByTagNameNS(namespace, "layout").item(0)).getTextContent() != null) {
            layoutCode = node.getTextContent();
        }
        if ((nodeList = rootEl.getElementsByTagNameNS(namespace, "app")) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node linkNode;
                Element appElement = (Element)nodeList.item(i);
                String id = appElement.getAttribute("id");
                if (id == null) continue;
                String position = null;
                String hrefLink = null;
                String hrefType = null;
                Node positionNode = appElement.getElementsByTagNameNS(namespace, "position").item(0);
                if (positionNode != null) {
                    Element positionElement = (Element)positionNode;
                    position = positionElement.getTextContent();
                }
                if ((linkNode = appElement.getElementsByTagNameNS(namespace, "link").item(0)) != null) {
                    Element linkElement = (Element)linkNode;
                    hrefLink = linkElement.getAttribute("href");
                    hrefType = linkElement.getAttribute("type");
                }
                omdlInputAdapter.addToAppMap(new OmdlWidgetReference(id, hrefLink, hrefType), position);
            }
        }
        omdlInputAdapter.setLayoutCode(layoutCode);
        omdlInputAdapter.setLayoutCode(OmdlModelUtils.getRaveLayoutForImport(omdlInputAdapter));
    }

    private Document initializeBuilder(String rawXml) {
        Document xmlRoot = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            xmlRoot = db.parse(new InputSource(new StringReader(rawXml)));
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
        return xmlRoot;
    }
}

