/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageInvitationStatus;
import org.apache.rave.model.PageLayout;
import org.apache.rave.model.PageTemplate;
import org.apache.rave.model.PageType;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.model.impl.PageImpl;
import org.apache.rave.portal.model.impl.PageUserImpl;
import org.apache.rave.portal.model.impl.RegionImpl;
import org.apache.rave.portal.model.impl.RegionWidgetImpl;
import org.apache.rave.portal.repository.PageLayoutRepository;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.repository.PageTemplateRepository;
import org.apache.rave.portal.repository.RegionRepository;
import org.apache.rave.portal.repository.RegionWidgetRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.util.PageUtil;
import org.apache.rave.repository.Repository;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultPageService
implements PageService {
    private final PageRepository pageRepository;
    private final RegionRepository regionRepository;
    private final RegionWidgetRepository regionWidgetRepository;
    private final WidgetRepository widgetRepository;
    private final PageLayoutRepository pageLayoutRepository;
    private final UserService userService;
    private final PageTemplateRepository pageTemplateRepository;
    private final String defaultPageName;
    private final String MOVE_PAGE_DEFAULT_POSITION_INDEX = "-1";

    @Autowired
    public DefaultPageService(PageRepository pageRepository, PageTemplateRepository pageTemplateRepository, RegionRepository regionRepository, WidgetRepository widgetRepository, RegionWidgetRepository regionWidgetRepository, PageLayoutRepository pageLayoutRepository, UserService userService, @Value(value="${portal.page.default_name}") String defaultPageName) {
        this.pageRepository = pageRepository;
        this.pageTemplateRepository = pageTemplateRepository;
        this.regionRepository = regionRepository;
        this.regionWidgetRepository = regionWidgetRepository;
        this.widgetRepository = widgetRepository;
        this.pageLayoutRepository = pageLayoutRepository;
        this.userService = userService;
        this.defaultPageName = defaultPageName;
    }

    @Override
    public SearchResult<Page> getAll() {
        List pages = this.pageRepository.getAll();
        int count = this.pageRepository.getCountAll();
        return new SearchResult(pages, count);
    }

    @Override
    public SearchResult<Page> getLimited(int offset, int limit) {
        List pages = this.pageRepository.getLimitedList(offset, limit);
        int count = this.pageRepository.getCountAll();
        SearchResult result = new SearchResult(pages, count);
        result.setOffset(offset);
        result.setPageSize(limit);
        return result;
    }

    @Override
    public Page getPage(String pageId) {
        return (Page)this.pageRepository.get(pageId);
    }

    @Override
    public List<Page> getAllUserPages(String userId) {
        return this.pageRepository.getAllPagesForUserType(userId, PageType.USER.toString());
    }

    @Override
    @Transactional
    public Page getPersonProfilePage(String userId) {
        List<Page> profilePages = this.pageRepository.getAllPagesForUserType(userId, PageType.PERSON_PROFILE.toString());
        Page personPage = null;
        personPage = profilePages.isEmpty() ? this.pageRepository.createPageForUser(this.userService.getUserById(userId), this.pageTemplateRepository.getDefaultPage(PageType.PERSON_PROFILE.toString())) : profilePages.get(0);
        return personPage;
    }

    @Override
    public List<Page> getPages(String context, String contextId) {
        return this.pageRepository.getPagesForContextType(contextId, context);
    }

    @Override
    public Page getPageFromList(String pageId, List<Page> pages) {
        for (Page page : pages) {
            if (!page.getId().equals(pageId)) continue;
            return page;
        }
        return null;
    }

    @Override
    public Page getDefaultPageFromList(List<Page> pages) {
        return pages == null || pages.isEmpty() ? null : pages.get(0);
    }

    @Override
    @Transactional
    public Page addNewPage(String pageName, String contextId, String pageTemplateId) {
        PageTemplate template = (PageTemplate)this.pageTemplateRepository.get(pageTemplateId);
        if (template == null) {
            throw new IllegalArgumentException("No page template found for the specified id " + pageTemplateId);
        }
        Page newInstance = PageUtil.convert(template, this.userService.getAuthenticatedUser(), false);
        newInstance.setContextId(contextId);
        newInstance.setName(pageName);
        return (Page)this.pageRepository.save(newInstance);
    }

    @Override
    @Transactional
    public Page addNewUserPage(String pageName, String pageLayoutCode) {
        return this.addNewUserPage(this.userService.getAuthenticatedUser(), pageName, pageLayoutCode);
    }

    @Override
    @Transactional
    public Page addNewDefaultUserPage(String userId) {
        User user = this.userService.getUserById(userId);
        return this.addNewUserPage(user, this.defaultPageName, user.getDefaultPageLayout().getCode());
    }

    @Override
    @Transactional
    public Page addNewSubPage(String pageName, String pageLayoutCode, Page parentPage) {
        return this.addNewSubPage(this.userService.getAuthenticatedUser(), pageName, pageLayoutCode, parentPage);
    }

    @Override
    public String getDefaultPageName() {
        return this.defaultPageName;
    }

    @Override
    @Transactional
    public void deletePage(String pageId) {
        User user = this.userService.getAuthenticatedUser();
        this.pageRepository.delete(this.pageRepository.get(pageId));
        ArrayList<PageUser> thisUsersPages = new ArrayList<PageUser>(this.pageRepository.getPagesForUser(user.getId(), PageType.USER.toString()));
        this.updatePageRenderSequences(thisUsersPages);
    }

    @Override
    @Transactional
    public int deletePages(String userId, String pageType) {
        return this.pageRepository.deletePages(userId, pageType);
    }

    @Override
    @Transactional
    public RegionWidget moveRegionWidget(String regionWidgetId, int newPosition, String toRegionId, String fromRegionId) {
        Region target = DefaultPageService.getFromRepository(toRegionId, this.regionRepository);
        RegionWidget regionWidget = (RegionWidget)this.regionWidgetRepository.get(regionWidgetId);
        this.verifyRegionWidgetIsNotLocked(regionWidget);
        this.verifyRegionIsNotLocked(target);
        if (toRegionId.equals(fromRegionId)) {
            this.moveWithinRegion(regionWidgetId, newPosition, target);
        } else {
            this.moveBetweenRegions(regionWidgetId, newPosition, fromRegionId, target);
        }
        target = (Region)this.regionRepository.save(target);
        return DefaultPageService.findRegionWidgetById(regionWidgetId, target.getRegionWidgets());
    }

    @Override
    @Transactional
    public RegionWidget moveRegionWidgetToPage(String regionWidgetId, String toPageId) {
        Page toPage = DefaultPageService.getFromRepository(toPageId, this.pageRepository);
        RegionWidget regionWidget = DefaultPageService.getFromRepository(regionWidgetId, this.regionWidgetRepository);
        Region moveFromRegion = regionWidget.getRegion();
        Region moveToRegion = (Region)toPage.getRegions().get(0);
        this.verifyRegionWidgetIsNotLocked(regionWidget);
        this.verifyRegionIsNotLocked(moveToRegion);
        regionWidget.setRenderOrder(0);
        regionWidget.setRegion(moveToRegion);
        moveToRegion.getRegionWidgets().add(0, regionWidget);
        moveFromRegion.getRegionWidgets().remove(regionWidget);
        DefaultPageService.updateRenderSequences(moveToRegion.getRegionWidgets());
        DefaultPageService.updateRenderSequences(moveFromRegion.getRegionWidgets());
        this.regionRepository.save(moveToRegion);
        this.regionRepository.save(moveFromRegion);
        return DefaultPageService.getFromRepository(regionWidgetId, this.regionWidgetRepository);
    }

    @Override
    @Transactional
    public Region removeWidgetFromPage(String regionWidgetId) {
        RegionWidget regionWidget = DefaultPageService.getFromRepository(regionWidgetId, this.regionWidgetRepository);
        this.verifyRegionWidgetIsNotLocked(regionWidget);
        this.regionWidgetRepository.delete(regionWidget);
        return DefaultPageService.getFromRepository(regionWidget.getRegion().getId(), this.regionRepository);
    }

    @Override
    @Transactional
    public RegionWidget addWidgetToPage(String pageId, String widgetId) {
        Page page = DefaultPageService.getFromRepository(pageId, this.pageRepository);
        Widget widget = DefaultPageService.getFromRepository(widgetId, this.widgetRepository);
        Region region = (Region)page.getRegions().get(0);
        this.verifyRegionIsNotLocked(region);
        return this.createWidgetInstance(widget, region, 0);
    }

    @Override
    @Transactional
    public RegionWidget addWidgetToPageRegion(String pageId, String widgetId, String regionId) {
        Page page = DefaultPageService.getFromRepository(pageId, this.pageRepository);
        Widget widget = DefaultPageService.getFromRepository(widgetId, this.widgetRepository);
        for (Region region : page.getRegions()) {
            if (!region.getId().equals(regionId)) continue;
            this.verifyRegionIsNotLocked(region);
            return this.createWidgetInstance(widget, region, 0);
        }
        return null;
    }

    @Override
    @Transactional
    public Page movePage(String pageId, String moveAfterPageId) {
        return this.doMovePage(pageId, moveAfterPageId);
    }

    @Override
    @Transactional
    public Page movePageToDefault(String pageId) {
        return this.doMovePage(pageId, "-1");
    }

    @Override
    @Transactional
    public Page updatePage(String pageId, String name, String pageLayoutCode) {
        return this.updatePage(pageId, name, pageLayoutCode, null);
    }

    @Override
    @Transactional
    public Page updatePage(String pageId, String name, String pageLayoutCode, Map<String, Object> properties) {
        PageLayout curLayout;
        Page page = (Page)this.pageRepository.get(pageId);
        PageLayout newLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        if (this.isLayoutAdjustmentNeeded(newLayout, curLayout = page.getPageLayout())) {
            if (curLayout.getNumberOfRegions() > newLayout.getNumberOfRegions()) {
                this.reduceRegionsForPage(page, newLayout.getNumberOfRegions());
            } else {
                long numberOfNewRegionsToAdd = newLayout.getNumberOfRegions() - curLayout.getNumberOfRegions();
                this.createAdditionalRegionsForPage(page, numberOfNewRegionsToAdd);
            }
        }
        page.setName(name);
        page.setPageLayout(newLayout);
        if (properties != null) {
            page.setProperties(properties);
        }
        return (Page)this.pageRepository.save(page);
    }

    @Override
    @Transactional
    public Page clonePageForUser(String pageId, String userId, String pageName) {
        Page page = this.getPage(pageId);
        if (pageName == null || pageName.equals("null")) {
            pageName = page.getName();
        }
        User user = this.userService.getUserById(userId);
        Page clonedPage = this.addNewUserPage(user, pageName, page.getPageLayout().getCode());
        if (page.getRegions().size() == 0) {
            ArrayList emptyRegions = Lists.newArrayList();
            clonedPage.setRegions((List)emptyRegions);
            clonedPage = (Page)this.pageRepository.save(clonedPage);
        }
        this.cloneRegionWidgets(page, clonedPage);
        List subPages = page.getSubPages();
        for (Page subPage : subPages) {
            clonedPage = DefaultPageService.getFromRepository(clonedPage.getId(), this.pageRepository);
            Page updatedPage = this.addNewSubPage(user, subPage.getName(), subPage.getPageLayout().getCode(), clonedPage);
            Page clonedSubPage = null;
            for (Page newSubPage : updatedPage.getSubPages()) {
                if (!newSubPage.getName().equals(subPage.getName()) || !newSubPage.getPageLayout().getCode().equals(subPage.getPageLayout().getCode())) continue;
                clonedSubPage = newSubPage;
                break;
            }
            if (clonedSubPage == null) continue;
            this.cloneRegionWidgets(subPage, clonedSubPage);
        }
        if ((clonedPage = DefaultPageService.getFromRepository(clonedPage.getId(), this.pageRepository)).getSubPages() == null) {
            clonedPage.setSubPages(new ArrayList());
        }
        clonedPage.setProperties(page.getProperties());
        PageUser pageUser = (PageUser)clonedPage.getMembers().get(0);
        User currentUser = this.userService.getAuthenticatedUser();
        if (currentUser.getId().equals(user.getId())) {
            pageUser.setPageStatus(PageInvitationStatus.OWNER);
        } else {
            pageUser.setPageStatus(PageInvitationStatus.PENDING);
        }
        return (Page)this.pageRepository.save(clonedPage);
    }

    @Override
    @Transactional
    public Boolean addMemberToPage(String pageId, String userId) {
        Page page = this.getPage(pageId);
        PageUserImpl pageUser = new PageUserImpl();
        pageUser.setUserId(this.userService.getUserById(userId).getId());
        pageUser.setPage(page);
        pageUser.setPageStatus(PageInvitationStatus.PENDING);
        List<PageUser> thisUsersPages = this.pageRepository.getPagesForUser(this.userService.getUserById(userId).getId(), PageType.USER.toString());
        pageUser.setRenderSequence(new Long(thisUsersPages.size() + 1));
        page.getMembers().add(pageUser);
        if (this.pageRepository.save(page) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    @Transactional
    public Boolean removeMemberFromPage(String pageId, String userId) {
        Page page = this.getPage(pageId);
        if (page.getOwnerId().equals(userId)) {
            this.pageRepository.delete(page);
            return true;
        }
        PageUser pageUserToRemove = null;
        for (PageUser pageUser : page.getMembers()) {
            if (!pageUser.getUserId().equals(userId)) continue;
            pageUserToRemove = pageUser;
            break;
        }
        if (pageUserToRemove != null) {
            page.getMembers().remove(pageUserToRemove);
            if (this.pageRepository.save(page) != null) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean updateSharedPageStatus(String pageId, String shareStatus) {
        Page page = this.getPage(pageId);
        for (PageUser pageUser : page.getMembers()) {
            if (!pageUser.getUserId().equals(this.userService.getAuthenticatedUser().getId())) continue;
            pageUser.setPageStatus(PageInvitationStatus.get((String)shareStatus));
        }
        if (this.pageRepository.save(page) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    @Transactional
    public Boolean updateSharedPageStatus(String pageId, String userId, String shareStatus) {
        Page page = this.getPage(pageId);
        for (PageUser pageUser : page.getMembers()) {
            if (!pageUser.getUserId().equals(userId)) continue;
            pageUser.setPageStatus(PageInvitationStatus.get((String)shareStatus));
        }
        if (this.pageRepository.save(page) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    @Transactional
    public Boolean updatePageEditingStatus(String pageId, String userId, boolean isEditor) {
        Page page = this.getPage(pageId);
        for (PageUser pageUser : page.getMembers()) {
            if (!pageUser.getUserId().equals(this.userService.getUserById(userId).getId())) continue;
            pageUser.setEditor(isEditor);
        }
        if (this.pageRepository.save(page) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isLayoutAdjustmentNeeded(PageLayout newLayout, PageLayout curLayout) {
        return newLayout != null && !curLayout.equals(newLayout) && !curLayout.getNumberOfRegions().equals(newLayout.getNumberOfRegions());
    }

    private void createAdditionalRegionsForPage(Page page, long numberOfNewRegionsToAdd) {
        List regions = page.getRegions();
        int lastRegionRenderOrder = ((Region)regions.get(regions.size() - 1)).getRenderOrder() + 1;
        int i = 0;
        while ((long)i < numberOfNewRegionsToAdd) {
            RegionImpl newRegion = new RegionImpl();
            newRegion.setPage(page);
            newRegion.setRenderOrder(lastRegionRenderOrder++);
            newRegion.setLocked(false);
            regions.add(newRegion);
            ++i;
        }
    }

    private void reduceRegionsForPage(Page page, long numberOfRegionsInNewLayout) {
        List regions = page.getRegions();
        Region lastValidRegion = (Region)regions.get((int)(numberOfRegionsInNewLayout - 1L));
        while ((long)regions.size() > numberOfRegionsInNewLayout) {
            Region deletedRegion = (Region)regions.remove(regions.size() - 1);
            for (RegionWidget widget : deletedRegion.getRegionWidgets()) {
                this.moveRegionWidgetToNewRegion(widget, lastValidRegion);
            }
            this.regionRepository.delete(deletedRegion);
        }
        this.regionRepository.save(lastValidRegion);
    }

    private void moveRegionWidgetToNewRegion(RegionWidget regionWidget, Region moveToRegion) {
        List regionWidgets = moveToRegion.getRegionWidgets();
        int renderOrder = regionWidgets.isEmpty() ? 1 : ((RegionWidget)regionWidgets.get(regionWidgets.size() - 1)).getRenderOrder() + 1;
        regionWidget.setRegion(moveToRegion);
        regionWidget.setRenderOrder(renderOrder);
        moveToRegion.getRegionWidgets().add(regionWidget);
    }

    private RegionWidget createWidgetInstance(Widget widget, Region region, int position) {
        RegionWidgetImpl regionWidget = new RegionWidgetImpl();
        regionWidget.setRenderOrder(position);
        regionWidget.setWidgetId(widget.getId());
        regionWidget.setLocked(false);
        regionWidget.setHideChrome(false);
        regionWidget.setRegion(region);
        region.getRegionWidgets().add(position, regionWidget);
        DefaultPageService.updateRenderSequences(region.getRegionWidgets());
        Region persistedRegion = (Region)this.regionRepository.save(region);
        return (RegionWidget)persistedRegion.getRegionWidgets().get(position);
    }

    private void moveWithinRegion(String regionWidgetId, int newPosition, Region target) {
        this.replaceRegionWidget(regionWidgetId, newPosition, target, target);
        DefaultPageService.updateRenderSequences(target.getRegionWidgets());
    }

    private void moveBetweenRegions(String regionWidgetId, int newPosition, String fromRegion, Region target) {
        Region source = DefaultPageService.getFromRepository(fromRegion, this.regionRepository);
        this.replaceRegionWidget(regionWidgetId, newPosition, target, source);
        DefaultPageService.updateRenderSequences(source.getRegionWidgets());
        DefaultPageService.updateRenderSequences(target.getRegionWidgets());
        this.regionRepository.save(source);
    }

    private void replaceRegionWidget(String regionWidgetId, int newPosition, Region target, Region source) {
        RegionWidget widget = DefaultPageService.findRegionWidgetById(regionWidgetId, source.getRegionWidgets());
        source.getRegionWidgets().remove(widget);
        target.getRegionWidgets().add(newPosition, widget);
    }

    private Page addNewUserPage(User user, String pageName, String pageLayoutCode) {
        PageLayout pageLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        ArrayList<RegionImpl> regions = new ArrayList<RegionImpl>();
        int regionCount = 0;
        while ((long)regionCount < pageLayout.getNumberOfRegions()) {
            RegionImpl region = new RegionImpl();
            region.setRenderOrder(regionCount);
            region.setLocked(false);
            regions.add(region);
            ++regionCount;
        }
        PageImpl page = null;
        List<Page> defaultUserPage = this.pageRepository.getAllPagesForUserType(user.getId(), PageType.USER.toString());
        if (defaultUserPage.isEmpty()) {
            return this.pageRepository.createPageForUser(user, this.pageTemplateRepository.getDefaultPage(PageType.USER.toString()));
        }
        long renderSequence = defaultUserPage.size() + 1;
        page = new PageImpl();
        page.setName(pageName);
        page.setOwnerId(user.getId());
        page.setPageLayout(pageLayout);
        PageUserImpl pageUser = new PageUserImpl(page.getOwnerId(), page, renderSequence);
        pageUser.setPageStatus(PageInvitationStatus.OWNER);
        pageUser.setEditor(true);
        ArrayList<PageUserImpl> members = new ArrayList<PageUserImpl>();
        members.add(pageUser);
        page.setMembers(members);
        page.setRegions(regions);
        page.setPageType(PageType.USER.toString());
        return (Page)this.pageRepository.save(page);
    }

    private Page addNewSubPage(User user, String pageName, String pageLayoutCode, Page parentPage) {
        PageLayout pageLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        ArrayList<RegionImpl> regions = new ArrayList<RegionImpl>();
        List<PageImpl> parentsSubPages = new ArrayList<PageImpl>();
        int regionCount = 0;
        while ((long)regionCount < pageLayout.getNumberOfRegions()) {
            RegionImpl region = new RegionImpl();
            region.setRenderOrder(regionCount);
            region.setLocked(false);
            regions.add(region);
            ++regionCount;
        }
        long renderSequence = parentPage.getSubPages() != null ? (long)(parentPage.getSubPages().size() + 1) : 1L;
        PageImpl page = new PageImpl();
        page.setName(pageName);
        page.setOwnerId(user.getId());
        page.setPageLayout(pageLayout);
        page.setRegions(regions);
        page.setPageType(PageType.SUB_PAGE.toString());
        PageUserImpl pageUser = new PageUserImpl(page.getOwnerId(), page, renderSequence);
        pageUser.setPageStatus(PageInvitationStatus.OWNER);
        ArrayList<PageUserImpl> members = new ArrayList<PageUserImpl>();
        members.add(pageUser);
        page.setMembers(members);
        page.setParentPage(parentPage);
        if (parentPage.getSubPages() != null) {
            parentsSubPages = parentPage.getSubPages();
        }
        parentsSubPages.add(page);
        parentPage.setSubPages(parentsSubPages);
        return (Page)this.pageRepository.save(page);
    }

    private void updatePageRenderSequences(List<PageUser> pages) {
        if (pages != null && !pages.isEmpty()) {
            for (int i = 0; i < pages.size(); ++i) {
                PageUser p = pages.get(i);
                p.setRenderSequence(Long.valueOf((long)i + 1L));
            }
            for (PageUser page : pages) {
                this.pageRepository.save(page.getPage());
            }
        }
    }

    private Page doMovePage(String pageId, String moveAfterPageId) {
        ArrayList<PageUser> thisUsersPages;
        User user = this.userService.getAuthenticatedUser();
        PageUser movingPageUser = this.pageRepository.getSingleRecord(user.getId(), pageId);
        PageUser afterPageUser = null;
        int newIndex = 0;
        if (moveAfterPageId != "-1") {
            afterPageUser = this.pageRepository.getSingleRecord(user.getId(), moveAfterPageId);
        }
        if (!(thisUsersPages = new ArrayList<PageUser>(this.pageRepository.getPagesForUser(user.getId(), PageType.USER.toString()))).remove(movingPageUser)) {
            throw new RuntimeException("unable to find pageId " + pageId + " attempted to be moved for user " + user);
        }
        if (afterPageUser != null) {
            newIndex = thisUsersPages.indexOf(afterPageUser) + 1;
        }
        thisUsersPages.add(newIndex, movingPageUser);
        this.updatePageRenderSequences(thisUsersPages);
        return movingPageUser.getPage();
    }

    private static <T> T getFromRepository(String id, Repository<T> repo) {
        Object object = repo.get(id);
        if (object == null) {
            throw new IllegalArgumentException("Could not find object of given id in " + repo.getClass().getSimpleName());
        }
        return (T)object;
    }

    private static void updateRenderSequences(List<RegionWidget> regionWidgets) {
        int count = 0;
        for (RegionWidget widget : regionWidgets) {
            widget.setRenderOrder(count);
            ++count;
        }
    }

    private static RegionWidget findRegionWidgetById(String id, List<RegionWidget> regionWidgets) {
        for (RegionWidget widget : regionWidgets) {
            if (!widget.getId().equals(id)) continue;
            return widget;
        }
        throw new IllegalArgumentException("Invalid RegionWidget ID");
    }

    private void verifyRegionIsNotLocked(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("region is null");
        }
        if (region.isLocked()) {
            throw new UnsupportedOperationException("Can't modify locked Region: " + region);
        }
    }

    private void verifyRegionWidgetIsNotLocked(RegionWidget regionWidget) {
        if (regionWidget == null) {
            throw new IllegalArgumentException("regionWidget is null");
        }
        if (regionWidget.isLocked()) {
            throw new UnsupportedOperationException("Can't modify locked RegionWidget: " + regionWidget);
        }
        this.verifyRegionIsNotLocked(regionWidget.getRegion());
    }

    private void cloneRegionWidgets(Page sourcePage, Page destinationPage) {
        for (int i = 0; i < sourcePage.getRegions().size(); ++i) {
            for (int j = ((Region)sourcePage.getRegions().get(i)).getRegionWidgets().size() - 1; j >= 0; --j) {
                String widgetId = ((RegionWidget)((Region)sourcePage.getRegions().get(i)).getRegionWidgets().get(j)).getWidgetId();
                this.addWidgetToPageRegion(destinationPage.getId(), widgetId, ((Region)destinationPage.getRegions().get(i)).getId());
            }
        }
    }
}

