/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.portal.events.PortalPreferenceJavascriptDebugModeSaveEvent;
import org.apache.rave.portal.events.RaveEventManager;
import org.apache.rave.portal.model.impl.PortalPreferenceImpl;
import org.apache.rave.portal.repository.PortalPreferenceRepository;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultPortalPreferenceService
implements PortalPreferenceService {
    private final PortalPreferenceRepository repository;
    private final RaveEventManager eventManager;

    @Autowired
    public DefaultPortalPreferenceService(PortalPreferenceRepository repository, RaveEventManager manager) {
        this.repository = repository;
        this.eventManager = manager;
    }

    @Override
    public Map<String, PortalPreference> getPreferencesAsMap() {
        List portalPreferences = this.repository.getAll();
        HashMap<String, PortalPreference> preferenceMap = new HashMap<String, PortalPreference>();
        for (PortalPreference preference : portalPreferences) {
            preferenceMap.put(preference.getKey(), preference);
        }
        return preferenceMap;
    }

    @Override
    public PortalPreference getPreference(String key) {
        return this.repository.getByKey(key);
    }

    @Override
    public SearchResult<PortalPreference> getAll() {
        int count = this.repository.getCountAll();
        List portalPreferences = this.repository.getAll();
        return new SearchResult(portalPreferences, count);
    }

    @Override
    public SearchResult<PortalPreference> getLimitedList(int offset, int pageSize) {
        int count = this.repository.getCountAll();
        List portalPreferences = this.repository.getLimitedList(offset, pageSize);
        SearchResult searchResult = new SearchResult(portalPreferences, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    @Transactional
    public void savePreference(String key, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.savePreference(key, values);
    }

    @Override
    @Transactional
    public void savePreference(String key, List<String> values) {
        PortalPreference preference = this.getPreference(key);
        if (preference == null) {
            preference = new PortalPreferenceImpl(key, values);
        } else {
            preference.setValues(values);
        }
        this.savePreference(preference);
    }

    @Override
    @Transactional
    public void savePreference(PortalPreference preference) {
        this.repository.save(preference);
        if (preference.getKey().equals("javaScriptDebugMode")) {
            this.eventManager.fireEvent(new PortalPreferenceJavascriptDebugModeSaveEvent(this));
        }
    }
}

