/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.List;
import org.apache.rave.model.Region;
import org.apache.rave.portal.repository.RegionRepository;
import org.apache.rave.portal.service.RegionService;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultRegionService
implements RegionService {
    private final RegionRepository regionRepository;

    @Autowired
    public DefaultRegionService(RegionRepository regionRepository) {
        this.regionRepository = regionRepository;
    }

    @Override
    @Transactional
    public void registerNewRegion(Region region) {
        this.regionRepository.save(region);
    }

    @Override
    public SearchResult<Region> getAll() {
        int count = this.regionRepository.getCountAll();
        List regions = this.regionRepository.getAll();
        return new SearchResult(regions, count);
    }

    @Override
    public SearchResult<Region> getLimitedList(int offset, int pageSize) {
        int count = this.regionRepository.getCountAll();
        List regions = this.regionRepository.getLimitedList(offset, pageSize);
        SearchResult searchResult = new SearchResult(regions, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }
}

