/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.List;
import org.apache.rave.model.Tag;
import org.apache.rave.portal.repository.TagRepository;
import org.apache.rave.portal.service.TagService;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultTagService
implements TagService {
    private final TagRepository repository;

    @Autowired
    public DefaultTagService(TagRepository repository) {
        this.repository = repository;
    }

    @Override
    public Tag getTagById(String entityId) {
        return (Tag)this.repository.get(entityId);
    }

    @Override
    public List<Tag> getAllTagsList() {
        return this.repository.getAll();
    }

    @Override
    public SearchResult<Tag> getAll() {
        int count = this.repository.getCountAll();
        List tags = this.repository.getAll();
        return new SearchResult(tags, count);
    }

    @Override
    public SearchResult<Tag> getLimitedList(int offset, int pageSize) {
        int count = this.repository.getCountAll();
        List tags = this.repository.getLimitedList(offset, pageSize);
        SearchResult searchResult = new SearchResult(tags, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public Tag getTagByKeyword(String keyword) {
        return this.repository.getByKeyword(keyword);
    }

    @Override
    @Transactional
    public Tag save(Tag tag) {
        return (Tag)this.repository.save(tag);
    }
}

