/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.model.PageType;
import org.apache.rave.model.Person;
import org.apache.rave.model.User;
import org.apache.rave.portal.repository.CategoryRepository;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.repository.PageTemplateRepository;
import org.apache.rave.portal.repository.PersonRepository;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.EmailService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.rest.model.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userService")
public class DefaultUserService
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final UserRepository userRepository;
    private final PageRepository pageRepository;
    private final PageTemplateRepository pageTemplateRepository;
    private final WidgetRepository widgetRepository;
    private final CategoryRepository categoryRepository;
    private final PersonRepository personRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private EmailService emailService;
    @Value(value="${portal.mail.passwordservice.subject}")
    private String passwordReminderSubject;
    @Value(value="${portal.mail.passwordservice.template}")
    private String passwordReminderTemplate;
    @Value(value="${portal.mail.username.subject}")
    private String userNameReminderSubject;
    @Value(value="${portal.mail.username.template}")
    private String userNameReminderTemplate;
    @Value(value="${portal.mail.service.baseurl}")
    private String baseUrl;
    @Value(value="${portal.user.account.admin.subject}")
    private String userAccountApprovalSubject;
    @Value(value="${portal.user.account.admin.template}")
    private String userAccountApprovalTemplate;
    @Value(value="${portal.user.account.needapproval}")
    private boolean userAccountApproval;
    @Value(value="${portal.user.account.admin.email}")
    private String approvalAdminEmail;
    @Value(value="${portal.mail.service.loginpage}")
    private String loginUrl;

    @Autowired
    public DefaultUserService(PageRepository pageRepository, UserRepository userRepository, WidgetRepository widgetRepository, PageTemplateRepository pageTemplateRepository, CategoryRepository categoryRepository, PersonRepository personRepository) {
        this.userRepository = userRepository;
        this.pageRepository = pageRepository;
        this.widgetRepository = widgetRepository;
        this.pageTemplateRepository = pageTemplateRepository;
        this.categoryRepository = categoryRepository;
        this.personRepository = personRepository;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        log.debug("loadUserByUsername called with: {}", (Object)username);
        User user = this.userRepository.getByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("User with username '" + username + "' was not found!");
        }
        return user;
    }

    @Override
    public User getAuthenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof User) {
            return (User)authentication.getPrincipal();
        }
        throw new SecurityException("Could not get the authenticated user!");
    }

    @Override
    public void setAuthenticatedUser(String userId) {
        User user = (User)this.userRepository.get(userId);
        if (user == null) {
            throw new UsernameNotFoundException("User with id '" + userId + "' was not found!");
        }
        SecurityContext securityContext = this.createContext(user);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
    }

    @Override
    public void clearAuthenticatedUser() {
        SecurityContextHolder.clearContext();
    }

    private SecurityContext createContext(final User user) {
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication((Authentication)new AbstractAuthenticationToken(user.getAuthorities()){
            private static final long serialVersionUID = 1L;

            public Object getCredentials() {
                return "N/A";
            }

            public Object getPrincipal() {
                return user;
            }

            public boolean isAuthenticated() {
                return true;
            }
        });
        return securityContext;
    }

    @Override
    @Transactional
    public void registerNewUser(User user) {
        if (this.userAccountApproval) {
            user.setEnabled(false);
        }
        User managedUser = (User)this.userRepository.save(user);
        this.pageRepository.createPageForUser(managedUser, this.pageTemplateRepository.getDefaultPage(PageType.PERSON_PROFILE.toString()));
        if (this.userAccountApproval && !this.approvalAdminEmail.isEmpty()) {
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("user", user);
            templateData.put("portalUrl", this.loginUrl);
            this.emailService.sendEmail(this.approvalAdminEmail, this.userAccountApprovalSubject, this.userAccountApprovalTemplate, templateData);
        }
    }

    @Override
    public User getUserById(String id) {
        return (User)this.userRepository.get(id);
    }

    @Override
    public User getUserByUsername(String userName) {
        return this.userRepository.getByUsername(userName);
    }

    @Override
    public User getUserByEmail(String userEmail) {
        return this.userRepository.getByUserEmail(userEmail);
    }

    @Override
    public User getUserByOpenId(String openId) {
        return this.userRepository.getByOpenId(openId);
    }

    @Override
    @Transactional
    public void updateUserProfile(User user) {
        this.userRepository.save(user);
    }

    @Override
    public SearchResult<User> getAll() {
        int count = this.userRepository.getCountAll();
        List users = this.userRepository.getAll();
        return new SearchResult(users, count);
    }

    @Override
    public SearchResult<User> getLimitedList(int offset, int pageSize) {
        int count = this.userRepository.getCountAll();
        List<User> users = this.userRepository.getLimitedList(offset, pageSize);
        SearchResult searchResult = new SearchResult(users, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Person> getLimitedListOfPersons(int offset, int pageSize) {
        SearchResult<User> users = this.getLimitedList(offset, pageSize);
        int count = users.getTotalResults();
        ArrayList<Person> people = new ArrayList<Person>();
        Person person = null;
        for (User user : users.getResultSet()) {
            person = user.toPerson();
            person.setId(user.getId());
            people.add(person);
        }
        SearchResult searchResult = new SearchResult(people, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<User> getUsersByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        int count = this.userRepository.getCountByUsernameOrEmail(searchTerm);
        List<User> users = this.userRepository.findByUsernameOrEmail(searchTerm, offset, pageSize);
        SearchResult searchResult = new SearchResult(users, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Person> getPersonsByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        SearchResult<User> users = this.getUsersByFreeTextSearch(searchTerm, offset, pageSize);
        int count = users.getTotalResults();
        ArrayList<Person> people = new ArrayList<Person>();
        Person person = null;
        for (User user : users.getResultSet()) {
            person = user.toPerson();
            person.setId(user.getId());
            people.add(person);
        }
        return new SearchResult(people, count);
    }

    @Override
    public List<Person> getAllPeople() {
        return this.personRepository.getAll();
    }

    @Override
    @Transactional
    public void deleteUser(String userId) {
        log.info("about to delete userId: " + userId);
        User user = (User)this.userRepository.get(userId);
        if (user == null) {
            log.warn("unable to find userId " + userId + " to delete");
            return;
        }
        String username = user.getUsername();
        int numDeletedPages = this.pageRepository.deletePages(userId, PageType.USER.toString());
        int numDeletedPersonPages = this.pageRepository.deletePages(userId, PageType.PERSON_PROFILE.toString());
        int numWidgetComments = this.widgetRepository.deleteAllWidgetComments(userId);
        int numWidgetRatings = this.widgetRepository.deleteAllWidgetRatings(userId);
        int numWidgetsOwned = this.widgetRepository.unassignWidgetOwner(userId);
        int numCategoriesTouched = this.categoryRepository.removeFromCreatedOrModifiedFields(userId);
        int numAssociationsRemoved = this.personRepository.removeAllFriendsAndRequests(userId);
        this.userRepository.delete(user);
        log.info("Deleted user [" + userId + ',' + username + "] - numPages: " + numDeletedPages + ", numPersonPages:" + numDeletedPersonPages + ", numWidgetComments: " + numWidgetComments + ", numWidgetRatings: " + numWidgetRatings + ", numWidgetsOwned: " + numWidgetsOwned + ", numCategoriesTouched:" + numCategoriesTouched + ", numAssociationRemoved:" + numAssociationsRemoved);
    }

    @Override
    public List<Person> getAllByAddedWidget(String widgetId) {
        ArrayList<Person> persons = new ArrayList<Person>();
        List<User> users = this.userRepository.getAllByAddedWidget(widgetId);
        for (User u : users) {
            persons.add(u.toPerson());
        }
        return persons;
    }

    @Override
    public void updatePassword(User newUser) {
        log.debug("Changing password  for user {}", (Object)newUser);
        User user = this.userRepository.getByForgotPasswordHash(newUser.getForgotPasswordHash());
        if (user == null) {
            throw new IllegalArgumentException("Could not find user for forgotPasswordHash " + newUser.getForgotPasswordHash());
        }
        String saltedHashedPassword = this.passwordEncoder.encode((CharSequence)newUser.getPassword());
        user.setPassword(saltedHashedPassword);
        user.setForgotPasswordHash(null);
        user.setForgotPasswordTime(null);
        this.userRepository.save(user);
    }

    @Override
    public void sendUserNameReminder(User newUser) {
        log.debug("Calling send username  {}", (Object)newUser);
        User user = this.userRepository.getByUserEmail(newUser.getEmail());
        if (user == null) {
            throw new IllegalArgumentException("Could not find user for email " + newUser.getEmail());
        }
        String to = user.getUsername() + " <" + user.getEmail() + '>';
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("user", user);
        this.emailService.sendEmail(to, this.userNameReminderSubject, this.userNameReminderTemplate, templateData);
    }

    @Override
    public void sendPasswordReminder(User newUser) {
        log.debug("Calling send password change link for user {}", (Object)newUser);
        User user = this.userRepository.getByUserEmail(newUser.getEmail());
        if (user == null) {
            throw new IllegalArgumentException("Could not find user for email " + newUser.getEmail());
        }
        String input = user.getEmail() + user.getUsername() + String.valueOf(user.getId()) + System.nanoTime();
        String safeString = new String(Base64.encode((byte[])this.passwordEncoder.encode((CharSequence)input).getBytes()));
        String hashedInput = safeString.replaceAll("[/=]", "A");
        user.setForgotPasswordHash(hashedInput);
        user.setForgotPasswordTime(Calendar.getInstance().getTime());
        this.userRepository.save(user);
        String to = user.getUsername() + " <" + user.getEmail() + '>';
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("user", user);
        templateData.put("reminderUrl", this.baseUrl + hashedInput);
        this.emailService.sendEmail(to, this.passwordReminderSubject, this.passwordReminderTemplate, templateData);
    }

    @Override
    public boolean isValidReminderRequest(String forgotPasswordHash, int nrOfMinutesValid) {
        if (StringUtils.isBlank((CharSequence)forgotPasswordHash)) {
            return false;
        }
        User userForHash = this.userRepository.getByForgotPasswordHash(forgotPasswordHash);
        if (userForHash == null) {
            return false;
        }
        Date requestTime = userForHash.getForgotPasswordTime();
        Calendar expiredDate = Calendar.getInstance();
        expiredDate.add(12, nrOfMinutesValid);
        if (requestTime == null || requestTime.after(expiredDate.getTime())) {
            userForHash.setForgotPasswordHash(null);
            userForHash.setForgotPasswordTime(null);
            this.userRepository.save(userForHash);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean addFriend(String friendUsername, String username) {
        return this.personRepository.addFriend(friendUsername, username);
    }

    @Override
    @Transactional
    public void removeFriend(String friendUsername, String username) {
        this.personRepository.removeFriend(friendUsername, username);
    }

    @Override
    public HashMap<String, List<Person>> getFriendsAndRequests(String username) {
        return this.personRepository.findFriendsAndRequests(username);
    }

    @Override
    public List<Person> getFriendRequestsReceived(String username) {
        return this.personRepository.findFriendRequestsReceived(username);
    }

    @Override
    @Transactional
    public boolean acceptFriendRequest(String friendUsername, String username) {
        return this.personRepository.acceptFriendRequest(friendUsername, username);
    }

    public UserDetails loadUserDetails(OpenIDAuthenticationToken token) throws UsernameNotFoundException {
        String openId = token.getIdentityUrl();
        User user = this.getUserByOpenId(openId);
        if (user == null) {
            log.info("Open ID User with URL " + openId + " was not found!");
            throw new UsernameNotFoundException("Open ID User with URL " + openId + " was not found!");
        }
        return user;
    }
}

