/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import javax.servlet.http.HttpServletRequest;
import net.tanesha.recaptcha.ReCaptcha;
import net.tanesha.recaptcha.ReCaptchaFactory;
import net.tanesha.recaptcha.ReCaptchaResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.portal.service.CaptchaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReCaptchaService
implements CaptchaService {
    private static Logger log = LoggerFactory.getLogger(ReCaptchaService.class);
    public static final String PARAM_CAPTCHA_RESPONSE = "recaptcha_response_field";
    public static final String PARAM_CAPTCHA_CHALLENGE = "recaptcha_challenge_field";
    private String invalidConfigurationMessage;
    private boolean captchaEnabled;
    private String publicKey;
    private boolean createNoScript;
    private String privateKey;

    @Autowired
    public ReCaptchaService(@Value(value="${portal.captcha.enabled}") boolean captchaEnabled, @Value(value="${portal.captcha.key.public}") String publicKey, @Value(value="${portal.captcha.key.private}") String privateKey, @Value(value="${portal.captcha.usenoscript}") boolean createNoScript, @Value(value="${portal.captcha.invalid.configuration}") String invalidConfigurationMessage) {
        this.captchaEnabled = captchaEnabled;
        this.publicKey = publicKey;
        this.createNoScript = createNoScript;
        this.privateKey = privateKey;
        this.invalidConfigurationMessage = invalidConfigurationMessage;
    }

    @Override
    public boolean isValid(HttpServletRequest request) {
        log.debug("ReCaptcha enabled:  {}", (Object)this.captchaEnabled);
        if (!this.captchaEnabled) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.privateKey) || StringUtils.isBlank((CharSequence)this.publicKey)) {
            log.error("ReCaptcha service is enabled, however, private or public keys are not defined.");
            return true;
        }
        boolean secure = request.isSecure();
        ReCaptcha captcha = secure ? ReCaptchaFactory.newSecureReCaptcha((String)this.publicKey, (String)this.privateKey, (boolean)this.createNoScript) : ReCaptchaFactory.newReCaptcha((String)this.publicKey, (String)this.privateKey, (boolean)this.createNoScript);
        String response = request.getParameter(PARAM_CAPTCHA_RESPONSE);
        String challenge = request.getParameter(PARAM_CAPTCHA_CHALLENGE);
        String remoteAddress = request.getRemoteAddr();
        ReCaptchaResponse captchaResponse = captcha.checkAnswer(remoteAddress, challenge, response);
        boolean valid = captchaResponse.isValid();
        if (valid) {
            return true;
        }
        log.warn("Invalid captcha response:  {}", (Object)captchaResponse.getErrorMessage());
        return false;
    }

    @Override
    public String createHtml(HttpServletRequest request) {
        if (this.captchaEnabled) {
            if (StringUtils.isBlank((CharSequence)this.privateKey) || StringUtils.isBlank((CharSequence)this.publicKey)) {
                return this.invalidConfigurationMessage;
            }
            boolean secure = request.isSecure();
            ReCaptcha captcha = secure ? ReCaptchaFactory.newSecureReCaptcha((String)this.publicKey, (String)this.privateKey, (boolean)this.createNoScript) : ReCaptchaFactory.newReCaptcha((String)this.publicKey, (String)this.privateKey, (boolean)this.createNoScript);
            return captcha.createRecaptchaHtml(null, null);
        }
        return "";
    }
}

