/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.util.data;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.rave.util.JsonUtils;
import org.springframework.core.io.Resource;

public class DataImporter<T> {
    protected Executor<T> dataExecutor;
    protected List<Resource> scriptLocations;
    protected Class<T> modelClass;

    public List<Resource> getScriptLocations() {
        return this.scriptLocations;
    }

    public void setScriptLocations(List<Resource> scriptLocations) {
        this.scriptLocations = scriptLocations;
    }

    @PostConstruct
    public void importData() {
        if (this.scriptLocations != null && this.dataExecutor.needsLoading()) {
            for (Resource resource : this.scriptLocations) {
                Object wrapper = JsonUtils.parse((Resource)resource, this.modelClass);
                this.dataExecutor.loadData(wrapper);
            }
        }
    }

    public void setDataExecutor(Executor<T> dataExecutor) {
        this.dataExecutor = dataExecutor;
    }

    public void setModelClass(Class<T> modelClass) {
        this.modelClass = modelClass;
    }

    public static interface Executor<T> {
        public boolean needsLoading();

        public void loadData(T var1);
    }
}

