/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.renderer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.portal.web.renderer.RenderScope;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.apache.rave.synchronization.annotation.Synchronized;
import org.springframework.stereotype.Service;

@Service
public class DefaultScriptManager
implements ScriptManager {
    private static final String KEY = "KEY";
    private final Map<ScriptLocation, Map<String, String>> scriptRenderers = new HashMap<ScriptLocation, Map<String, String>>();

    @Override
    public List<String> getScriptBlocks(ScriptLocation location, RenderContext context) {
        LinkedHashMap<String, String> combined = new LinkedHashMap<String, String>();
        DefaultScriptManager.getAndAdd(location, combined, this.scriptRenderers);
        DefaultScriptManager.getAndAdd(location, combined, DefaultScriptManager.getOrCreateScriptMap(context));
        ArrayList<String> scriptContent = new ArrayList<String>();
        for (Map.Entry entry : combined.entrySet()) {
            scriptContent.add((String)entry.getValue());
        }
        return scriptContent;
    }

    @Override
    public void registerScriptBlock(String key, String script, ScriptLocation location) {
        DefaultScriptManager.addScriptToMap(key, script, location, this.scriptRenderers);
    }

    @Override
    public void registerScriptBlock(String key, String script, ScriptLocation location, RenderScope scope, RenderContext context) {
        switch (scope) {
            case GLOBAL: {
                this.registerScriptBlock(key, script, location);
                break;
            }
            case CURRENT_REQUEST: {
                DefaultScriptManager.addScriptToContext(key, script, location, context);
                break;
            }
            default: {
                throw new NotSupportedException("The scope, " + (Object)((Object)scope) + " , is not supported by the script manager");
            }
        }
    }

    private static void getAndAdd(ScriptLocation location, Map<String, String> output, Map<ScriptLocation, Map<String, String>> map) {
        Map<String, String> scripts = map.get((Object)location);
        if (scripts != null) {
            output.putAll(scripts);
        }
    }

    private static void addScriptToContext(String key, String script, ScriptLocation location, RenderContext context) {
        Map<ScriptLocation, Map<String, String>> scriptMap = DefaultScriptManager.getOrCreateScriptMap(context);
        DefaultScriptManager.addScriptToMap(key, script, location, scriptMap);
    }

    private static void addScriptToMap(String key, String script, ScriptLocation location, Map<ScriptLocation, Map<String, String>> scripts) {
        if (!scripts.containsKey((Object)location)) {
            DefaultScriptManager.addMapForLocation(location, scripts);
        }
        scripts.get((Object)location).put(key, script);
    }

    @Synchronized(discriminator="'SM_#map.toString()'", id="#location")
    private static void addMapForLocation(ScriptLocation location, Map<ScriptLocation, Map<String, String>> map) {
        if (!map.containsKey((Object)location)) {
            map.put(location, new LinkedHashMap());
        }
    }

    private static Map<ScriptLocation, Map<String, String>> getOrCreateScriptMap(RenderContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot have a null render context");
        }
        HashMap scriptMap = (HashMap)context.getProperties().get(KEY);
        if (scriptMap == null) {
            scriptMap = new HashMap();
            context.getProperties().put(KEY, scriptMap);
        }
        return scriptMap;
    }
}

