/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.renderer.RenderService;
import org.apache.rave.rest.PagesForRenderResource;
import org.apache.rave.rest.exception.ResourceNotFoundException;
import org.apache.rave.rest.model.Page;
import org.apache.rave.rest.model.SearchResult;

public class DefaultPageForRenderResource
implements PagesForRenderResource {
    public static final String SELF = "@self";
    private PageService pageService;
    private RenderService renderService;
    private UserService userService;

    public SearchResult<Page> getPagesForRender(String context, String identifier) {
        List<org.apache.rave.model.Page> pages;
        if ("portal".equals(context)) {
            try {
                String userId = SELF.equals(identifier) ? this.userService.getAuthenticatedUser().getId() : identifier;
                pages = this.pageService.getAllUserPages(userId);
            }
            catch (Exception e) {
                throw new ResourceNotFoundException(identifier);
            }
        } else if ("profile".equals(context)) {
            try {
                pages = Arrays.asList(this.pageService.getPersonProfilePage(identifier));
            }
            catch (Exception e) {
                throw new ResourceNotFoundException(identifier);
            }
        } else {
            throw new ResourceNotFoundException("Context " + context + " not found");
        }
        if (pages == null) {
            throw new ResourceNotFoundException(identifier);
        }
        ArrayList converted = Lists.newArrayList();
        for (org.apache.rave.model.Page page : pages) {
            Page convert = new Page(page);
            converted.add(this.renderService.prepareForRender(convert));
        }
        return new SearchResult((List)converted, converted.size());
    }

    public Page getPageForRender(String context, String identifier, String id) {
        org.apache.rave.model.Page page;
        if ("portal".equals(context)) {
            String userId = SELF.equals(identifier) ? this.userService.getAuthenticatedUser().getId() : identifier;
            page = this.pageService.getPage(id);
        } else if ("profile".equals(context)) {
            try {
                page = this.pageService.getPersonProfilePage(identifier);
            }
            catch (Exception e) {
                throw new ResourceNotFoundException(identifier);
            }
        } else {
            throw new ResourceNotFoundException("Context " + context + " not found");
        }
        if (page == null) {
            throw new ResourceNotFoundException(id);
        }
        Page converted = this.renderService.prepareForRender(new Page(page));
        return converted;
    }

    @Inject
    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    @Inject
    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }

    @Inject
    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

