/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.impl;

import java.util.List;
import javax.inject.Inject;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.rest.PageUsersResource;
import org.apache.rave.rest.exception.BadRequestException;
import org.apache.rave.rest.exception.ResourceNotFoundException;
import org.apache.rave.rest.model.Page;
import org.apache.rave.rest.model.PageUser;
import org.apache.rave.rest.model.SearchResult;

public class DefaultPageUsersResource
implements PageUsersResource {
    private Page page;
    private PageService pageService;

    public void setPage(Page page) {
        this.page = page;
    }

    public SearchResult<PageUser> getPageUsers() {
        List members = this.page.getMembers();
        SearchResult result = new SearchResult(members, members.size());
        return result;
    }

    public PageUser createPageUser(PageUser user) {
        if (user.getPersonId() == null) {
            throw new BadRequestException("Page user personId property must be defined.");
        }
        this.pageService.addMemberToPage(this.page.getId(), user.getPersonId());
        this.pageService.updatePageEditingStatus(this.page.getId(), user.getPersonId(), user.isEditor());
        return user;
    }

    public PageUser getPageUser(String userId) {
        List members = this.page.getMembers();
        PageUser match = null;
        for (PageUser user : members) {
            if (!user.getPersonId().equals(userId)) continue;
            match = user;
            break;
        }
        if (match == null) {
            throw new ResourceNotFoundException(userId);
        }
        return match;
    }

    public PageUser updatePageUser(String userId, PageUser user) {
        PageUser oldUser = this.getPageUser(userId);
        if (user.getPersonId() == null) {
            throw new BadRequestException("Page user status property must be defined.");
        }
        if (oldUser.isEditor() != user.isEditor()) {
            this.pageService.updatePageEditingStatus(this.page.getId(), userId, user.isEditor());
        }
        if (!oldUser.getStatus().equals(user.getStatus())) {
            this.pageService.updateSharedPageStatus(this.page.getId(), userId, user.getStatus());
        }
        return user;
    }

    public PageUser deletePageUser(String userId) {
        PageUser user = this.getPageUser(userId);
        this.pageService.removeMemberFromPage(this.page.getId(), user.getPersonId());
        return null;
    }

    @Inject
    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }
}

